/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.services.LogService;
import jakarta.inject.Inject;
import lombok.Generated;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@KestraTest
class LogServiceTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogServiceTest.class);
    @Inject
    private LogService logService;

    LogServiceTest() {
    }

    @Test
    void logFlow() {
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("namespace")).id("flow")).build();
        this.logService.logExecution((FlowId)flow, log, Level.INFO, "Some log", new Object[0]);
        this.logService.logExecution((FlowId)flow, log, Level.INFO, "Some log with an {}", new Object[]{"attribute"});
        this.logService.logExecution((FlowId)flow, log, Level.ERROR, "Some log with an {} and an error", new Object[]{"attribute", new RuntimeException("Test Exception")});
    }

    @Test
    void logExecution() {
        Execution execution = Execution.builder().namespace("namespace").flowId("flow").id("execution").build();
        this.logService.logExecution(execution, log, Level.INFO, "Some log", new Object[0]);
        this.logService.logExecution(execution, log, Level.INFO, "Some log with an {}", new Object[]{"attribute"});
        this.logService.logExecution(execution, Level.INFO, "Some log", new Object[0]);
    }

    @Test
    void logTrigger() {
        TriggerContext trigger = TriggerContext.builder().namespace("namespace").flowId("flow").triggerId("trigger").build();
        this.logService.logTrigger(trigger, log, Level.INFO, "Some log", new Object[0]);
        this.logService.logTrigger(trigger, log, Level.INFO, "Some log with an {}", new Object[]{"attribute"});
        this.logService.logTrigger(trigger, Level.INFO, "Some log", new Object[0]);
    }

    @Test
    void logTaskRun() {
        TaskRun taskRun = TaskRun.builder().namespace("namespace").flowId("flow").executionId("execution").taskId("task").id("taskRun").build();
        this.logService.logTaskRun(taskRun, Level.INFO, "Some log", new Object[0]);
        this.logService.logTaskRun(taskRun, Level.INFO, "Some log with an {}", new Object[]{"attribute"});
        taskRun = TaskRun.builder().namespace("namespace").flowId("flow").executionId("execution").taskId("task").id("taskRun").value("value").build();
        this.logService.logTaskRun(taskRun, Level.INFO, "Some log", new Object[0]);
        this.logService.logTaskRun(taskRun, Level.INFO, "Some log with an {}", new Object[]{"attribute"});
    }
}

