/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.FlowProcessingException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.PluginDefault;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.services.PluginDefaultService;
import io.kestra.core.services.PluginDefaultServiceTest;
import io.kestra.core.services.PluginGlobalDefaultConfiguration;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KestraTest
class PluginDefaultServiceOverrideTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginDefaultServiceOverrideTest.class);
    @Inject
    private PluginDefaultService pluginDefaultService;

    PluginDefaultServiceOverrideTest() {
    }

    @Execution(value=ExecutionMode.SAME_THREAD)
    @ParameterizedTest
    @MethodSource
    void flowDefaultsOverrideGlobalDefaults(boolean flowDefaultForced, boolean globalDefaultForced, String fooValue, String barValue, String bazValue) throws FlowProcessingException {
        Task task = ((PluginDefaultServiceTest.DefaultPrecedenceTester.DefaultPrecedenceTesterBuilder)((Object)((PluginDefaultServiceTest.DefaultPrecedenceTester.DefaultPrecedenceTesterBuilder)((PluginDefaultServiceTest.DefaultPrecedenceTester.DefaultPrecedenceTesterBuilder)PluginDefaultServiceTest.DefaultPrecedenceTester.builder().id("test")).type(PluginDefaultServiceTest.DefaultPrecedenceTester.class.getName())).propBaz("taskValue"))).build();
        PluginDefault flowDefault = new PluginDefault(PluginDefaultServiceTest.DefaultPrecedenceTester.class.getName(), flowDefaultForced, (Map)ImmutableMap.of((Object)"propBar", (Object)"flowValue", (Object)"propBaz", (Object)"flowValue"));
        PluginDefault globalDefault = new PluginDefault(PluginDefaultServiceTest.DefaultPrecedenceTester.class.getName(), globalDefaultForced, (Map)ImmutableMap.of((Object)"propFoo", (Object)"globalValue", (Object)"propBar", (Object)"globalValue", (Object)"propBaz", (Object)"globalValue"));
        String tenant = TestsUtils.randomTenant((String[])new String[]{PluginDefaultServiceOverrideTest.class.getSimpleName()});
        Flow flowWithPluginDefault = ((Flow.FlowBuilder)Flow.builder().tenantId(tenant)).tasks(Collections.singletonList(task)).pluginDefaults(List.of(flowDefault)).build();
        PluginGlobalDefaultConfiguration pluginGlobalDefaultConfiguration = new PluginGlobalDefaultConfiguration();
        pluginGlobalDefaultConfiguration.defaults = List.of(globalDefault);
        PluginGlobalDefaultConfiguration previousGlobalDefault = this.pluginDefaultService.pluginGlobalDefault;
        this.pluginDefaultService.pluginGlobalDefault = pluginGlobalDefaultConfiguration;
        FlowWithSource injected = this.pluginDefaultService.injectAllDefaults((FlowInterface)flowWithPluginDefault, true);
        this.pluginDefaultService.pluginGlobalDefault = previousGlobalDefault;
        MatcherAssert.assertThat((Object)((PluginDefaultServiceTest.DefaultPrecedenceTester)((Object)injected.getTasks().getFirst())).getPropFoo(), (Matcher)Matchers.is((Object)fooValue));
        MatcherAssert.assertThat((Object)((PluginDefaultServiceTest.DefaultPrecedenceTester)((Object)injected.getTasks().getFirst())).getPropBar(), (Matcher)Matchers.is((Object)barValue));
        MatcherAssert.assertThat((Object)((PluginDefaultServiceTest.DefaultPrecedenceTester)((Object)injected.getTasks().getFirst())).getPropBaz(), (Matcher)Matchers.is((Object)bazValue));
    }

    private static Stream<Arguments> flowDefaultsOverrideGlobalDefaults() {
        return Stream.of(Arguments.of((Object[])new Object[]{false, false, "globalValue", "flowValue", "taskValue"}), Arguments.of((Object[])new Object[]{false, true, "globalValue", "globalValue", "globalValue"}), Arguments.of((Object[])new Object[]{true, false, "globalValue", "flowValue", "flowValue"}), Arguments.of((Object[])new Object[]{true, true, "globalValue", "flowValue", "flowValue"}));
    }
}

