/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.kestra.core.exceptions.FlowProcessingException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.flows.PluginDefault;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.PluginDefaultService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.Expression;
import io.kestra.plugin.core.log.Log;
import io.kestra.plugin.core.trigger.Schedule;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;

@KestraTest
class PluginDefaultServiceTest {
    private static final Map<String, Object> TEST_FLOW_AS_MAP = Map.of("id", "test", "namespace", "type", "tasks", List.of(Map.of("id", "my-task", "type", "io.kestra.test")));
    public static final String TEST_LOG_FLOW_SOURCE = "    id: test\n    namespace: io.kestra.unittest\n    tasks:\n     - id: log\n       type: io.kestra.plugin.core.log.Log\n";
    @Inject
    private PluginDefaultService pluginDefaultService;

    PluginDefaultServiceTest() {
    }

    @Test
    void shouldInjectGivenFlowWithNullSource() throws FlowProcessingException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{PluginDefaultServiceTest.class.getSimpleName()});
        GenericFlow flow = GenericFlow.fromYaml((String)tenant, (String)TEST_LOG_FLOW_SOURCE);
        FlowWithSource result = this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, true);
        Log task = (Log)result.getTasks().getFirst();
        MatcherAssert.assertThat((Object)task.getMessage(), (Matcher)Matchers.is((Object)"This is a default message"));
    }

    @Test
    void shouldInjectGivenDefaultsIncludingType() {
        Map<String, List<PluginDefault>> defaults = Map.of("io.kestra.test", List.of(new PluginDefault("io.kestra.test", false, Map.of("taskRunner", Map.of("type", "io.kestra.test")))));
        Object result = this.pluginDefaultService.recursiveDefaults(TEST_FLOW_AS_MAP, defaults);
        Assertions.assertEquals(Map.of("id", "test", "namespace", "type", "tasks", List.of(Map.of("id", "my-task", "type", "io.kestra.test", "taskRunner", Map.of("type", "io.kestra.test")))), (Object)result);
    }

    @Test
    void shouldInjectGivenSimpleDefaults() {
        Map<String, List<PluginDefault>> defaults = Map.of("io.kestra.test", List.of(new PluginDefault("io.kestra.test", false, Map.of("default-key", "default-value"))));
        Object result = this.pluginDefaultService.recursiveDefaults(TEST_FLOW_AS_MAP, defaults);
        Assertions.assertEquals(Map.of("id", "test", "namespace", "type", "tasks", List.of(Map.of("id", "my-task", "type", "io.kestra.test", "default-key", "default-value"))), (Object)result);
    }

    @Test
    public void injectFlowAndGlobals() throws FlowProcessingException, JsonProcessingException {
        String source = String.format("id: default-test\nnamespace: io.kestra.tests\n\ntriggers:\n- id: trigger\n  type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTriggerTester\n  conditions:\n  - type: io.kestra.plugin.core.condition.ExpressionCondition\n\ntasks:\n- id: test\n  type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n  set: 666\n\npluginDefaults:\n- type: \"%s\"\n  forced: false\n  values:\n    set: 123\n    value: 1\n    arrays: [1]\n- type: \"%s\"\n  forced: false\n  values:\n    set: 123\n- type: \"%s\"\n  forced: false\n  values:\n    expression: \"{{ test }}\"\n", DefaultTester.class.getName(), DefaultTriggerTester.class.getName(), Expression.class.getName());
        String tenant = TestsUtils.randomTenant((String[])new String[]{PluginDefaultServiceTest.class.getSimpleName()});
        FlowWithSource injected = this.pluginDefaultService.parseFlowWithAllDefaults(tenant, source, false);
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getValue(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getSet(), (Matcher)Matchers.is((Object)666));
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getDoubleValue(), (Matcher)Matchers.is((Object)19.0));
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getArrays().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(((DefaultTester)((Object)injected.getTasks().getFirst())).getArrays(), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2}));
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getProperty().getHere(), (Matcher)Matchers.is((Object)"me"));
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getProperty().getLists().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getProperty().getLists().getFirst().getVal().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getProperty().getLists().getFirst().getVal().get("key"), (Matcher)Matchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)((DefaultTriggerTester)((Object)injected.getTriggers().getFirst())).getSet(), (Matcher)Matchers.is((Object)123));
        MatcherAssert.assertThat((Object)((Expression)((AbstractTrigger)injected.getTriggers().getFirst()).getConditions().getFirst()).getExpression().toString(), (Matcher)Matchers.is((Object)"{{ test }}"));
    }

    @Test
    public void shouldInjectForcedDefaultsGivenForcedTrue() throws FlowProcessingException {
        String source = "    id: default-test\n    namespace: io.kestra.tests\n\n    tasks:\n    - id: test\n      type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n      set: 1\n\n    pluginDefaults:\n    - type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n      forced: true\n      values:\n        set: 2\n    - type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n      forced: true\n      values:\n        set: 3\n    - type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n      forced: false\n      values:\n        set: 4\n        value: 1\n        arrays: [1]\n";
        String tenant = TestsUtils.randomTenant((String[])new String[]{PluginDefaultServiceTest.class.getSimpleName()});
        FlowWithSource injected = this.pluginDefaultService.parseFlowWithAllDefaults(tenant, source, false);
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getSet(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void shouldInjectDefaultGivenPrefixType() throws FlowProcessingException {
        String source = "id: default-test\nnamespace: io.kestra.tests\n\ntriggers:\n- id: trigger\n  type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTriggerTester\n  conditions:\n  - type: io.kestra.plugin.core.condition.ExpressionCondition\n\ntasks:\n- id: test\n  type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n  set: 666\n\npluginDefaults:\n- type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n  values:\n    set: 789\n- type: io.kestra.core.services.\n  values:\n    set: 456\n    value: 2\n- type: io.kestra.core.services2.\n  values:\n    value: 3\n";
        String tenant = TestsUtils.randomTenant((String[])new String[]{PluginDefaultServiceTest.class.getSimpleName()});
        FlowWithSource injected = this.pluginDefaultService.parseFlowWithAllDefaults(tenant, source, false);
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getSet(), (Matcher)Matchers.is((Object)666));
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getValue(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    void shouldInjectFlowDefaultsGivenAlias() throws FlowProcessingException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{PluginDefaultServiceTest.class.getSimpleName()});
        GenericFlow flow = GenericFlow.fromYaml((String)tenant, (String)"  id: default-test\n  namespace: io.kestra.tests\n\n  tasks:\n  - id: test\n    type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n    set: 666\n\n  pluginDefaults:\n     - type: io.kestra.core.services.DefaultTesterAlias\n       values:\n         value: 1\n");
        FlowWithSource injected = this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, true);
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getValue(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    void shouldInjectFlowDefaultsGivenType() throws FlowProcessingException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{PluginDefaultServiceTest.class.getSimpleName()});
        GenericFlow flow = GenericFlow.fromYaml((String)tenant, (String)"      id: default-test\n      namespace: io.kestra.tests\n\n      tasks:\n      - id: test\n        type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n        set: 666\n\n      pluginDefaults:\n         - type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n           values:\n             defaultValue: overridden\n");
        FlowWithSource injected = this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, true);
        MatcherAssert.assertThat((Object)((DefaultTester)((Object)injected.getTasks().getFirst())).getDefaultValue(), (Matcher)Matchers.is((Object)"overridden"));
    }

    @Test
    public void shouldNotInjectDefaultsGivenExistingTaskValue() throws FlowProcessingException {
        String tenant = TestsUtils.randomTenant((String[])new String[]{PluginDefaultServiceTest.class.getSimpleName()});
        GenericFlow flow = GenericFlow.fromYaml((String)tenant, (String)"  id: default-test\n  namespace: io.kestra.tests\n\n  tasks:\n  - id: test\n    type: io.kestra.plugin.core.log.Log\n    message: testing\n    level: INFO\n\n  pluginDefaults:\n   - type: io.kestra.core.services.PluginDefaultServiceTest$DefaultTester\n     values:\n       defaultValue: WARN\n");
        FlowWithSource injected = this.pluginDefaultService.injectAllDefaults((FlowInterface)flow, true);
        MatcherAssert.assertThat((Object)((Log)injected.getTasks().getFirst()).getLevel().toString(), (Matcher)Matchers.is((Object)Level.INFO.name()));
    }

    @Plugin(aliases={"io.kestra.core.services.DefaultTesterAlias"})
    public static class DefaultTester
    extends Task
    implements RunnableTask<VoidOutput> {
        private Collections property;
        private Integer value;
        private Double doubleValue;
        private Integer set;
        private List<Integer> arrays;
        private String defaultValue;

        public VoidOutput run(RunContext runContext) throws Exception {
            return null;
        }

        @Generated
        private static String $default$defaultValue() {
            return "default";
        }

        @Generated
        protected DefaultTester(DefaultTesterBuilder<?, ?> b) {
            super(b);
            this.property = b.property;
            this.value = b.value;
            this.doubleValue = b.doubleValue;
            this.set = b.set;
            this.arrays = b.arrays;
            this.defaultValue = b.defaultValue$set ? b.defaultValue$value : DefaultTester.$default$defaultValue();
        }

        @Generated
        public static DefaultTesterBuilder<?, ?> builder() {
            return new DefaultTesterBuilderImpl();
        }

        @Generated
        public String toString() {
            return "PluginDefaultServiceTest.DefaultTester(super=" + super.toString() + ", property=" + String.valueOf(this.getProperty()) + ", value=" + this.getValue() + ", doubleValue=" + this.getDoubleValue() + ", set=" + this.getSet() + ", arrays=" + String.valueOf(this.getArrays()) + ", defaultValue=" + this.getDefaultValue() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultTester)) {
                return false;
            }
            DefaultTester other = (DefaultTester)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$value = this.getValue();
            Integer other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            Double this$doubleValue = this.getDoubleValue();
            Double other$doubleValue = other.getDoubleValue();
            if (this$doubleValue == null ? other$doubleValue != null : !((Object)this$doubleValue).equals(other$doubleValue)) {
                return false;
            }
            Integer this$set = this.getSet();
            Integer other$set = other.getSet();
            if (this$set == null ? other$set != null : !((Object)this$set).equals(other$set)) {
                return false;
            }
            Collections this$property = this.getProperty();
            Collections other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            List<Integer> this$arrays = this.getArrays();
            List<Integer> other$arrays = other.getArrays();
            if (this$arrays == null ? other$arrays != null : !((Object)this$arrays).equals(other$arrays)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultTester;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            Double $doubleValue = this.getDoubleValue();
            result = result * 59 + ($doubleValue == null ? 43 : ((Object)$doubleValue).hashCode());
            Integer $set = this.getSet();
            result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
            Collections $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            List<Integer> $arrays = this.getArrays();
            result = result * 59 + ($arrays == null ? 43 : ((Object)$arrays).hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            return result;
        }

        @Generated
        public Collections getProperty() {
            return this.property;
        }

        @Generated
        public Integer getValue() {
            return this.value;
        }

        @Generated
        public Double getDoubleValue() {
            return this.doubleValue;
        }

        @Generated
        public Integer getSet() {
            return this.set;
        }

        @Generated
        public List<Integer> getArrays() {
            return this.arrays;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        public DefaultTester() {
            this.defaultValue = DefaultTester.$default$defaultValue();
        }

        @Generated
        public static abstract class DefaultTesterBuilder<C extends DefaultTester, B extends DefaultTesterBuilder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private Collections property;
            @Generated
            private Integer value;
            @Generated
            private Double doubleValue;
            @Generated
            private Integer set;
            @Generated
            private List<Integer> arrays;
            @Generated
            private boolean defaultValue$set;
            @Generated
            private String defaultValue$value;

            @Generated
            public B property(Collections property) {
                this.property = property;
                return (B)this.self();
            }

            @Generated
            public B value(Integer value) {
                this.value = value;
                return (B)this.self();
            }

            @Generated
            public B doubleValue(Double doubleValue) {
                this.doubleValue = doubleValue;
                return (B)this.self();
            }

            @Generated
            public B set(Integer set) {
                this.set = set;
                return (B)this.self();
            }

            @Generated
            public B arrays(List<Integer> arrays) {
                this.arrays = arrays;
                return (B)this.self();
            }

            @Generated
            public B defaultValue(String defaultValue) {
                this.defaultValue$value = defaultValue;
                this.defaultValue$set = true;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "PluginDefaultServiceTest.DefaultTester.DefaultTesterBuilder(super=" + super.toString() + ", property=" + String.valueOf(this.property) + ", value=" + this.value + ", doubleValue=" + this.doubleValue + ", set=" + this.set + ", arrays=" + String.valueOf(this.arrays) + ", defaultValue$value=" + this.defaultValue$value + ")";
            }
        }

        public static class Collections {
            private String here;
            private List<Lists> lists;

            @Generated
            public Collections() {
            }

            @Generated
            public String getHere() {
                return this.here;
            }

            @Generated
            public List<Lists> getLists() {
                return this.lists;
            }
        }

        @Generated
        private static final class DefaultTesterBuilderImpl
        extends DefaultTesterBuilder<DefaultTester, DefaultTesterBuilderImpl> {
            @Generated
            private DefaultTesterBuilderImpl() {
            }

            @Override
            @Generated
            protected DefaultTesterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DefaultTester build() {
                return new DefaultTester(this);
            }
        }

        public static class Lists {
            private Map<String, String> val;

            @Generated
            public Lists() {
            }

            @Generated
            public Map<String, String> getVal() {
                return this.val;
            }
        }
    }

    public static class DefaultTriggerTester
    extends AbstractTrigger
    implements PollingTriggerInterface,
    TriggerOutput<Schedule.Output> {
        private Integer set;

        public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws Exception {
            return Optional.empty();
        }

        public Duration getInterval() {
            return Duration.ofSeconds(1L);
        }

        @Generated
        protected DefaultTriggerTester(DefaultTriggerTesterBuilder<?, ?> b) {
            super(b);
            this.set = b.set;
        }

        @Generated
        public static DefaultTriggerTesterBuilder<?, ?> builder() {
            return new DefaultTriggerTesterBuilderImpl();
        }

        @Generated
        public String toString() {
            return "PluginDefaultServiceTest.DefaultTriggerTester(super=" + super.toString() + ", set=" + this.getSet() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultTriggerTester)) {
                return false;
            }
            DefaultTriggerTester other = (DefaultTriggerTester)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$set = this.getSet();
            Integer other$set = other.getSet();
            return !(this$set == null ? other$set != null : !((Object)this$set).equals(other$set));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultTriggerTester;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $set = this.getSet();
            result = result * 59 + ($set == null ? 43 : ((Object)$set).hashCode());
            return result;
        }

        @Generated
        public Integer getSet() {
            return this.set;
        }

        @Generated
        public DefaultTriggerTester() {
        }

        @Generated
        public static abstract class DefaultTriggerTesterBuilder<C extends DefaultTriggerTester, B extends DefaultTriggerTesterBuilder<C, B>>
        extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
            @Generated
            private Integer set;

            @Generated
            public B set(Integer set) {
                this.set = set;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "PluginDefaultServiceTest.DefaultTriggerTester.DefaultTriggerTesterBuilder(super=" + super.toString() + ", set=" + this.set + ")";
            }
        }

        @Generated
        private static final class DefaultTriggerTesterBuilderImpl
        extends DefaultTriggerTesterBuilder<DefaultTriggerTester, DefaultTriggerTesterBuilderImpl> {
            @Generated
            private DefaultTriggerTesterBuilderImpl() {
            }

            @Override
            @Generated
            protected DefaultTriggerTesterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DefaultTriggerTester build() {
                return new DefaultTriggerTester(this);
            }
        }
    }

    @Plugin(aliases={"io.kestra.core.services.DefaultPrecedenceTesterAlias"})
    public static class DefaultPrecedenceTester
    extends Task
    implements RunnableTask<VoidOutput> {
        private String propFoo;
        private String propBar;
        private String propBaz;

        public VoidOutput run(RunContext runContext) throws Exception {
            return null;
        }

        @Generated
        protected DefaultPrecedenceTester(DefaultPrecedenceTesterBuilder<?, ?> b) {
            super(b);
            this.propFoo = b.propFoo;
            this.propBar = b.propBar;
            this.propBaz = b.propBaz;
        }

        @Generated
        public static DefaultPrecedenceTesterBuilder<?, ?> builder() {
            return new DefaultPrecedenceTesterBuilderImpl();
        }

        @Generated
        public String toString() {
            return "PluginDefaultServiceTest.DefaultPrecedenceTester(super=" + super.toString() + ", propFoo=" + this.getPropFoo() + ", propBar=" + this.getPropBar() + ", propBaz=" + this.getPropBaz() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultPrecedenceTester)) {
                return false;
            }
            DefaultPrecedenceTester other = (DefaultPrecedenceTester)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$propFoo = this.getPropFoo();
            String other$propFoo = other.getPropFoo();
            if (this$propFoo == null ? other$propFoo != null : !this$propFoo.equals(other$propFoo)) {
                return false;
            }
            String this$propBar = this.getPropBar();
            String other$propBar = other.getPropBar();
            if (this$propBar == null ? other$propBar != null : !this$propBar.equals(other$propBar)) {
                return false;
            }
            String this$propBaz = this.getPropBaz();
            String other$propBaz = other.getPropBaz();
            return !(this$propBaz == null ? other$propBaz != null : !this$propBaz.equals(other$propBaz));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultPrecedenceTester;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $propFoo = this.getPropFoo();
            result = result * 59 + ($propFoo == null ? 43 : $propFoo.hashCode());
            String $propBar = this.getPropBar();
            result = result * 59 + ($propBar == null ? 43 : $propBar.hashCode());
            String $propBaz = this.getPropBaz();
            result = result * 59 + ($propBaz == null ? 43 : $propBaz.hashCode());
            return result;
        }

        @Generated
        public String getPropFoo() {
            return this.propFoo;
        }

        @Generated
        public String getPropBar() {
            return this.propBar;
        }

        @Generated
        public String getPropBaz() {
            return this.propBaz;
        }

        @Generated
        public DefaultPrecedenceTester() {
        }

        @Generated
        public static abstract class DefaultPrecedenceTesterBuilder<C extends DefaultPrecedenceTester, B extends DefaultPrecedenceTesterBuilder<C, B>>
        extends Task.TaskBuilder<C, B> {
            @Generated
            private String propFoo;
            @Generated
            private String propBar;
            @Generated
            private String propBaz;

            @Generated
            public B propFoo(String propFoo) {
                this.propFoo = propFoo;
                return (B)this.self();
            }

            @Generated
            public B propBar(String propBar) {
                this.propBar = propBar;
                return (B)this.self();
            }

            @Generated
            public B propBaz(String propBaz) {
                this.propBaz = propBaz;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "PluginDefaultServiceTest.DefaultPrecedenceTester.DefaultPrecedenceTesterBuilder(super=" + super.toString() + ", propFoo=" + this.propFoo + ", propBar=" + this.propBar + ", propBaz=" + this.propBaz + ")";
            }
        }

        @Generated
        private static final class DefaultPrecedenceTesterBuilderImpl
        extends DefaultPrecedenceTesterBuilder<DefaultPrecedenceTester, DefaultPrecedenceTesterBuilderImpl> {
            @Generated
            private DefaultPrecedenceTesterBuilderImpl() {
            }

            @Override
            @Generated
            protected DefaultPrecedenceTesterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DefaultPrecedenceTester build() {
                return new DefaultPrecedenceTester(this);
            }
        }
    }
}

