/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.services.SkipExecutionService;
import jakarta.inject.Inject;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@KestraTest
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class SkipExecutionServiceTest {
    @Inject
    private SkipExecutionService skipExecutionService;

    SkipExecutionServiceTest() {
    }

    @BeforeEach
    void resetAll() {
        this.skipExecutionService.setSkipExecutions(null);
        this.skipExecutionService.setSkipFlows(null);
        this.skipExecutionService.setSkipNamespaces(null);
        this.skipExecutionService.setSkipTenants(null);
        this.skipExecutionService.setSkipIndexerRecords(null);
    }

    @Test
    void skipExecutionByExecutionId() {
        String executionToSkip = "aaabbbccc";
        String executionNotToSkip = "bbbcccddd";
        this.skipExecutionService.setSkipExecutions(List.of(executionToSkip));
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(executionToSkip)).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(executionNotToSkip)).isFalse();
    }

    @Test
    void skipExecutionByExecution() {
        Execution executionToSkip = Execution.builder().id("skip").build();
        Execution executionToSkipByFlow = Execution.builder().id("id").namespace("namespace").flowId("skip").build();
        this.skipExecutionService.setSkipExecutions(List.of("skip"));
        this.skipExecutionService.setSkipFlows(List.of("namespace|skip"));
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(executionToSkip)).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(executionToSkipByFlow)).isTrue();
    }

    @Test
    void skipExecutionByTaskRun() {
        TaskRun taskRunToSkip = TaskRun.builder().executionId("skip").build();
        TaskRun taskRunToSkipByFlow = TaskRun.builder().id("id").namespace("namespace").flowId("skip").executionId("keep").build();
        this.skipExecutionService.setSkipExecutions(List.of("skip"));
        this.skipExecutionService.setSkipFlows(List.of("namespace|skip"));
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(taskRunToSkip)).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(taskRunToSkipByFlow)).isTrue();
    }

    @Test
    void skipExecutionByFlowId() {
        String flowToSkip = "namespace|skip";
        String flowToSkipWithTenant = "tenant|namespace|skip";
        this.skipExecutionService.setSkipFlows(List.of(flowToSkip, flowToSkipWithTenant));
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(null, "namespace", "skip", "random")).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(null, "wrong", "skip", "random")).isFalse();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("tenant", "namespace", "skip", "random")).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("wrong", "namespace", "skip", "random")).isFalse();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(null, "namespace", "not_skipped", "random")).isFalse();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("tenant", "namespace", "not_skipped", "random")).isFalse();
    }

    @Test
    void skipExecutionByNamespace() {
        this.skipExecutionService.setSkipNamespaces(List.of("tenant|namespace"));
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("tenant", "namespace", "someFlow", "someExecution")).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution(null, "namespace", "someFlow", "someExecution")).isFalse();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("anotherTenant", "namespace", "someFlow", "someExecution")).isFalse();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("tenant", "namespace", "anotherFlow", "anotherExecution")).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("tenant", "other.namespace", "someFlow", "someExecution")).isFalse();
    }

    @Test
    void skipExecutionByTenantId() {
        this.skipExecutionService.setSkipTenants(List.of("tenant"));
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("tenant", "namespace", "someFlow", "someExecution")).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("anotherTenant", "namespace", "someFlow", "someExecution")).isFalse();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("tenant", "another.namespace", "someFlow", "someExecution")).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipExecution("anotherTenant", "another.namespace", "someFlow", "someExecution")).isFalse();
    }

    @Test
    void skipIndexedRecords() {
        this.skipExecutionService.setSkipIndexerRecords(List.of("indexed"));
        Assertions.assertThat((boolean)this.skipExecutionService.skipIndexerRecord("indexed")).isTrue();
        Assertions.assertThat((boolean)this.skipExecutionService.skipIndexerRecord("notindexed")).isFalse();
    }
}

