/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.services.StartExecutorService;
import io.micronaut.context.annotation.Property;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
@Property(name="kestra.queue.type", value="kafka")
class StartExecutorServiceTest {
    @Inject
    private StartExecutorService startExecutorService;

    StartExecutorServiceTest() {
    }

    @Test
    void shouldStartExecutor() {
        Assertions.assertTrue((boolean)this.startExecutorService.shouldStartExecutor("ExecutorName"));
        this.startExecutorService.applyOptions(List.of("ExecutorName"), Collections.emptyList());
        Assertions.assertTrue((boolean)this.startExecutorService.shouldStartExecutor("ExecutorName"));
        this.startExecutorService.applyOptions(List.of("AnotherExecutorName"), Collections.emptyList());
        Assertions.assertFalse((boolean)this.startExecutorService.shouldStartExecutor("ExecutorName"));
        this.startExecutorService.applyOptions(Collections.emptyList(), List.of("AnotherExecutorName"));
        Assertions.assertTrue((boolean)this.startExecutorService.shouldStartExecutor("ExecutorName"));
        this.startExecutorService.applyOptions(Collections.emptyList(), List.of("ExecutorName"));
        Assertions.assertFalse((boolean)this.startExecutorService.shouldStartExecutor("ExecutorName"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.startExecutorService.applyOptions(List.of("ExecutorName"), List.of("AnotherExecutorName")));
    }
}

