/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.PluginDefault;
import io.kestra.core.services.TaskGlobalDefaultConfiguration;
import io.micronaut.context.ApplicationContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class TaskGlobalDefaultConfigurationTest {
    TaskGlobalDefaultConfigurationTest() {
    }

    @Test
    public void keepCase() {
        Map<String, String> env = Map.of("AB_VALUE", "test", "ABCVALUE", "test");
        Map<String, Map<String, String>> values = Map.of("env", env);
        Map<String, Map<String, Map<String, String>>> task = Map.of("type", "io.kestra.plugin.scripts.shell.Commands", "values", values);
        List<Map<String, Map<String, Map<String, String>>>> defaultTasks = List.of(task);
        Map<String, List<Map<String, Map<String, Map<String, String>>>>> defaults = Map.of("defaults", defaultTasks);
        Map<String, Map<String, List<Map<String, Map<String, Map<String, String>>>>>> tasks = Map.of("tasks", defaults);
        Map<String, Map<String, Map<String, List<Map<String, Map<String, Map<String, String>>>>>>> kestra = Map.of("kestra", tasks);
        try (ApplicationContext ctx = ApplicationContext.run(kestra, (String[])new String[]{"cli", "test"});){
            TaskGlobalDefaultConfiguration taskDefaultGlobalConfiguration = (TaskGlobalDefaultConfiguration)ctx.getBean(TaskGlobalDefaultConfiguration.class);
            Assertions.assertThat(((Map)((PluginDefault)taskDefaultGlobalConfiguration.getDefaults().getFirst()).getValues().get("env")).keySet()).isEqualTo(Set.of("AB_VALUE", "ABCVALUE"));
        }
    }
}

