/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.storages.InternalNamespace;
import io.kestra.core.storages.Namespace;
import io.kestra.core.storages.NamespaceFile;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.PathMatcherPredicate;
import io.kestra.storage.local.LocalStorage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalNamespaceTest {
    private static final Logger logger = LoggerFactory.getLogger(InternalNamespaceTest.class);
    LocalStorage storageInterface;

    InternalNamespaceTest() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        Path basePath = Files.createTempDirectory("unit", new FileAttribute[0]);
        this.storageInterface = new LocalStorage();
        this.storageInterface.setBasePath(basePath);
        this.storageInterface.init();
    }

    @Test
    void shouldGetAllNamespaceFiles() throws IOException, URISyntaxException {
        String namespaceId = "io.kestra." + IdUtils.create();
        InternalNamespace namespace = new InternalNamespace(logger, "main", namespaceId, (StorageInterface)this.storageInterface);
        namespace.putFile(Path.of("/sub/dir/file1.txt", new String[0]), (InputStream)new ByteArrayInputStream("1".getBytes()));
        namespace.putFile(Path.of("/sub/dir/file2.txt", new String[0]), (InputStream)new ByteArrayInputStream("2".getBytes()));
        namespace.putFile(Path.of("/sub/dir/file3.txt", new String[0]), (InputStream)new ByteArrayInputStream("3".getBytes()));
        Assertions.assertThat((List)namespace.all()).containsExactlyInAnyOrder((Object[])new NamespaceFile[]{NamespaceFile.of((String)namespaceId, (Path)Path.of("sub/dir/file1.txt", new String[0])), NamespaceFile.of((String)namespaceId, (Path)Path.of("sub/dir/file2.txt", new String[0])), NamespaceFile.of((String)namespaceId, (Path)Path.of("sub/dir/file3.txt", new String[0]))});
    }

    @Test
    void shouldPutFileGivenNoTenant() throws IOException, URISyntaxException {
        String namespaceId = "io.kestra." + IdUtils.create();
        InternalNamespace namespace = new InternalNamespace(logger, "main", namespaceId, (StorageInterface)this.storageInterface);
        NamespaceFile namespaceFile = namespace.putFile(Path.of("/sub/dir/file.txt", new String[0]), (InputStream)new ByteArrayInputStream("1".getBytes()));
        Assertions.assertThat((Object)namespaceFile).isEqualTo((Object)NamespaceFile.of((String)namespaceId, (Path)Path.of("sub/dir/file.txt", new String[0])));
        try (InputStream is = namespace.getFileContent(Path.of(namespaceFile.path(), new String[0]));){
            Assertions.assertThat((String)new String(is.readAllBytes())).isEqualTo("1");
        }
    }

    @Test
    void shouldSucceedPutFileGivenExistingFileForConflictOverwrite() throws IOException, URISyntaxException {
        String namespaceId = "io.kestra." + IdUtils.create();
        InternalNamespace namespace = new InternalNamespace(logger, "main", namespaceId, (StorageInterface)this.storageInterface);
        NamespaceFile namespaceFile = namespace.get(Path.of("/sub/dir/file.txt", new String[0]));
        namespace.putFile(namespaceFile, (InputStream)new ByteArrayInputStream("1".getBytes()));
        namespace.putFile(namespaceFile, (InputStream)new ByteArrayInputStream("2".getBytes()), Namespace.Conflicts.OVERWRITE);
        try (InputStream is = namespace.getFileContent(Path.of(namespaceFile.path(), new String[0]));){
            Assertions.assertThat((String)new String(is.readAllBytes())).isEqualTo("2");
        }
    }

    @Test
    void shouldFailPutFileGivenExistingFileForError() throws IOException, URISyntaxException {
        String namespaceId = "io.kestra." + IdUtils.create();
        InternalNamespace namespace = new InternalNamespace(logger, "main", namespaceId, (StorageInterface)this.storageInterface);
        NamespaceFile namespaceFile = namespace.get(Path.of("/sub/dir/file.txt", new String[0]));
        namespace.putFile(namespaceFile, (InputStream)new ByteArrayInputStream("1".getBytes()));
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> namespace.putFile(namespaceFile, (InputStream)new ByteArrayInputStream("2".getBytes()), Namespace.Conflicts.ERROR));
    }

    @Test
    void shouldIgnorePutFileGivenExistingFileForSkip() throws IOException, URISyntaxException {
        String namespaceId = "io.kestra." + IdUtils.create();
        InternalNamespace namespace = new InternalNamespace(logger, "main", namespaceId, (StorageInterface)this.storageInterface);
        NamespaceFile namespaceFile = namespace.get(Path.of("/sub/dir/file.txt", new String[0]));
        namespace.putFile(namespaceFile, (InputStream)new ByteArrayInputStream("1".getBytes()));
        namespace.putFile(namespaceFile, (InputStream)new ByteArrayInputStream("2".getBytes()), Namespace.Conflicts.SKIP);
        try (InputStream is = namespace.getFileContent(Path.of(namespaceFile.path(), new String[0]));){
            Assertions.assertThat((String)new String(is.readAllBytes())).isEqualTo("1");
        }
    }

    @Test
    void shouldFindAllMatchingGivenNoTenant() throws IOException, URISyntaxException {
        String namespaceId = "io.kestra." + IdUtils.create();
        InternalNamespace namespace = new InternalNamespace(logger, "main", namespaceId, (StorageInterface)this.storageInterface);
        namespace.putFile(Path.of("/a/b/c/1.sql", new String[0]), (InputStream)new ByteArrayInputStream("1".getBytes()));
        namespace.putFile(Path.of("/a/2.sql", new String[0]), (InputStream)new ByteArrayInputStream("2".getBytes()));
        namespace.putFile(Path.of("/b/c/d/3.sql", new String[0]), (InputStream)new ByteArrayInputStream("3".getBytes()));
        namespace.putFile(Path.of("/b/d/4.sql", new String[0]), (InputStream)new ByteArrayInputStream("4".getBytes()));
        namespace.putFile(Path.of("/c/5.sql", new String[0]), (InputStream)new ByteArrayInputStream("5".getBytes()));
        List namespaceFiles = namespace.findAllFilesMatching(PathMatcherPredicate.builder().includes(List.of("/a/**", "c/**")).excludes(List.of("**/2.sql")).build());
        Assertions.assertThat(namespaceFiles.stream().map(NamespaceFile::path).toList()).containsExactlyInAnyOrder((Object[])new String[]{"a/b/c/1.sql", "b/c/d/3.sql", "c/5.sql"});
    }

    @Test
    void shouldFindAllGivenTenant() throws IOException, URISyntaxException {
        String namespaceId = "io.kestra." + IdUtils.create();
        InternalNamespace namespaceTenant1 = new InternalNamespace(logger, "tenant1", namespaceId, (StorageInterface)this.storageInterface);
        NamespaceFile namespaceFile1 = namespaceTenant1.putFile(Path.of("/a/b/c/test.txt", new String[0]), (InputStream)new ByteArrayInputStream("1".getBytes()));
        InternalNamespace namespaceTenant2 = new InternalNamespace(logger, "tenant2", namespaceId, (StorageInterface)this.storageInterface);
        NamespaceFile namespaceFile2 = namespaceTenant2.putFile(Path.of("/a/b/c/test.txt", new String[0]), (InputStream)new ByteArrayInputStream("1".getBytes()));
        List allTenant1 = namespaceTenant1.all();
        Assertions.assertThat((int)allTenant1.size()).isEqualTo(1);
        Assertions.assertThat((List)allTenant1).containsExactlyInAnyOrder((Object[])new NamespaceFile[]{namespaceFile1});
        List allTenant2 = namespaceTenant2.all();
        Assertions.assertThat((int)allTenant2.size()).isEqualTo(1);
        Assertions.assertThat((List)allTenant2).containsExactlyInAnyOrder((Object[])new NamespaceFile[]{namespaceFile2});
    }

    @Test
    void shouldReturnNoNamespaceFileForEmptyNamespace() throws IOException {
        String namespaceId = "io.kestra." + IdUtils.create();
        InternalNamespace namespace = new InternalNamespace(logger, "main", namespaceId, (StorageInterface)this.storageInterface);
        List namespaceFiles = namespace.findAllFilesMatching(unused -> true);
        Assertions.assertThat((int)namespaceFiles.size()).isZero();
    }
}

