/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.storages.NamespaceFile;
import java.net.URI;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NamespaceFileTest {
    private static final String NAMESPACE = "io.kestra.test";

    NamespaceFileTest() {
    }

    @Test
    void shouldReturnTrueForIsRootDirectoryGivenRootDirectory() {
        Assertions.assertTrue((boolean)NamespaceFile.of((String)NAMESPACE, (URI)URI.create("/")).isRootDirectory());
    }

    @Test
    void shouldReturnFalseForIsRootDirectoryGivenNonRootDirectory() {
        Assertions.assertFalse((boolean)NamespaceFile.of((String)NAMESPACE, (URI)URI.create("/my/sub/dir")).isRootDirectory());
    }

    @Test
    void shouldCreateValidNamespaceFileGivenSlashURI() {
        NamespaceFile expected = new NamespaceFile(Path.of("", new String[0]), URI.create("kestra:///io/kestra/test/_files/"), NAMESPACE);
        Assertions.assertEquals((Object)expected, (Object)NamespaceFile.of((String)NAMESPACE, (URI)URI.create("/")));
        Assertions.assertEquals((Object)expected, (Object)NamespaceFile.of((String)NAMESPACE, (Path)Path.of("/", new String[0])));
    }

    @Test
    void shouldThrowExceptionGivenNullNamespace() {
        Assertions.assertThrows(NullPointerException.class, () -> NamespaceFile.of(null, (Path)null));
    }

    @Test
    void shouldThrowExceptionGivenInvalidScheme() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NamespaceFile.of((String)NAMESPACE, (URI)URI.create("file:///io/kestra/test/_files/sub/dir/file.txt")));
    }

    @Test
    void shouldThrowExceptionGivenInvalidNamespace() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NamespaceFile.of((String)NAMESPACE, (URI)URI.create("kestra:///com/acme/_files/sub/dir/file.txt")));
    }

    @Test
    void shouldCreateGivenNamespaceAndValidStorageURI() {
        Assertions.assertEquals((Object)new NamespaceFile(Path.of("sub/dir/file.txt", new String[0]), URI.create("kestra:///io/kestra/test/_files/sub/dir/file.txt"), NAMESPACE), (Object)NamespaceFile.of((String)NAMESPACE, (URI)URI.create("kestra:///io/kestra/test/_files/sub/dir/file.txt")));
    }

    @Test
    void shouldCreateGivenNamespaceAndValidRelativeURI() {
        Assertions.assertEquals((Object)new NamespaceFile(Path.of("sub/dir/file.txt", new String[0]), URI.create("kestra:///io/kestra/test/_files/sub/dir/file.txt"), NAMESPACE), (Object)NamespaceFile.of((String)NAMESPACE, (URI)URI.create("/sub/dir/file.txt")));
    }

    @Test
    void shouldCreateGivenNamespaceAndPath() {
        NamespaceFile expected = new NamespaceFile(Path.of("sub/dir/file.txt", new String[0]), URI.create("kestra:///io/kestra/test/_files/sub/dir/file.txt"), NAMESPACE);
        Assertions.assertEquals((Object)expected, (Object)NamespaceFile.of((String)NAMESPACE, (Path)Path.of("sub/dir/file.txt", new String[0])));
        Assertions.assertEquals((Object)expected, (Object)NamespaceFile.of((String)NAMESPACE, (Path)Path.of("/sub/dir/file.txt", new String[0])));
        Assertions.assertEquals((Object)expected, (Object)NamespaceFile.of((String)NAMESPACE, (Path)Path.of("./sub/dir/file.txt", new String[0])));
    }

    @Test
    void shouldCreateGivenNamespaceAndNullPath() {
        Assertions.assertEquals((Object)new NamespaceFile(Path.of("", new String[0]), URI.create("kestra:///io/kestra/test/_files/"), NAMESPACE), (Object)NamespaceFile.of((String)NAMESPACE));
    }

    @Test
    void shouldCreateGivenNamespaceAndRootPath() {
        Assertions.assertEquals((Object)new NamespaceFile(Path.of("", new String[0]), URI.create("kestra:///io/kestra/test/_files/"), NAMESPACE), (Object)NamespaceFile.of((String)NAMESPACE, (Path)Path.of("/", new String[0])));
    }

    @Test
    void shouldGetStoragePath() {
        NamespaceFile namespaceFile = new NamespaceFile(Path.of("sub/dir/file.txt", new String[0]), URI.create("kestra:///io/kestra/test/_files/sub/dir/file.txt"), NAMESPACE);
        Assertions.assertEquals((Object)Path.of("/io/kestra/test/_files/sub/dir/file.txt", new String[0]), (Object)namespaceFile.storagePath());
    }

    @Test
    void shouldPreserveTrailingSlashForUri() {
        NamespaceFile namespaceFile = NamespaceFile.of((String)NAMESPACE, (URI)URI.create("/sub/dir/"));
        Assertions.assertEquals((Object)new NamespaceFile(Path.of("sub/dir", new String[0]), URI.create("kestra:///io/kestra/test/_files/sub/dir/"), NAMESPACE), (Object)namespaceFile);
        Assertions.assertTrue((boolean)namespaceFile.isDirectory());
    }
}

