/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.exceptions.MigrationRequiredException;
import io.kestra.core.exceptions.ResourceExpiredException;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.kv.KVValue;
import io.kestra.core.utils.Hashing;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.log.Log;
import io.micronaut.test.extensions.junit5.annotation.MicronautTest;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@MicronautTest
public class StateStoreTest {
    @Inject
    private TestRunContextFactory runContextFactory;

    @Test
    void all() throws IOException, ResourceExpiredException {
        RunContext runContext = this.runContext();
        String state = IdUtils.create();
        runContext.stateStore().putState(state, "some-name", "my-taskrun-value", "my-value".getBytes());
        Assertions.assertThat((byte[])runContext.stateStore().getState(state, "some-name", "my-taskrun-value").readAllBytes()).isEqualTo((Object)"my-value".getBytes());
        RunContext.FlowInfo flowInfo = runContext.flowInfo();
        String key = flowInfo.id() + "_states_" + state + "_some-name_" + Hashing.hashToString((String)"my-taskrun-value");
        Assertions.assertThat((Object)((KVValue)runContext.namespaceKv(flowInfo.namespace()).getValue(key).get()).value()).isEqualTo((Object)"my-value".getBytes());
        runContext.stateStore().deleteState(state, "some-name", "my-taskrun-value");
        FileNotFoundException fileNotFoundException = (FileNotFoundException)org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> runContext.stateStore().getState(state, "some-name", "my-taskrun-value"));
        Assertions.assertThat((String)fileNotFoundException.getMessage()).isEqualTo("State " + key + " not found");
    }

    @Test
    void getState_WithOldStateStore_ShouldThrowMigrationException() throws IOException, ResourceExpiredException {
        RunContext runContext = this.runContext();
        String state = IdUtils.create();
        RunContext.FlowInfo flowInfo = runContext.flowInfo();
        URI oldStateStoreFileUri = URI.create("kestra:/" + flowInfo.namespace().replace(".", "/") + "/" + flowInfo.id() + "/states/" + state + "/" + Hashing.hashToString((String)"my-taskrun-value") + "/some-name");
        byte[] expectedContent = "from-old-state".getBytes();
        runContext.storage().putFile((InputStream)new ByteArrayInputStream(expectedContent), oldStateStoreFileUri);
        String key = flowInfo.id() + "_states_" + state + "_some-name_" + Hashing.hashToString((String)"my-taskrun-value");
        Assertions.assertThat((byte[])runContext.storage().getFile(oldStateStoreFileUri).readAllBytes()).isEqualTo((Object)expectedContent);
        MigrationRequiredException migrationRequiredException = (MigrationRequiredException)org.junit.jupiter.api.Assertions.assertThrows(MigrationRequiredException.class, () -> runContext.stateStore().getState(state, "some-name", "my-taskrun-value"));
        Assertions.assertThat((String)migrationRequiredException.getMessage()).isEqualTo("It looks like the State Store migration hasn't been run, please run the `/app/kestra sys state-store migrate` command before.");
        Assertions.assertThat((boolean)runContext.namespaceKv(flowInfo.namespace()).getValue(key).isEmpty()).isTrue();
    }

    @Test
    void subNameAndTaskrunValueOptional() throws IOException, ResourceExpiredException {
        RunContext runContext = this.runContext();
        String state = IdUtils.create();
        runContext.stateStore().putState(state, "a-name", "a-taskrun-value", "aa-value".getBytes());
        runContext.stateStore().putState(state, "a-name", "b-taskrun-value", "ab-value".getBytes());
        runContext.stateStore().putState(state, "b-name", "a-taskrun-value", "ba-value".getBytes());
        runContext.stateStore().putState(state, "b-name", "b-taskrun-value", "bb-value".getBytes());
        runContext.stateStore().putState(state, null, "a-taskrun-value", "0a-value".getBytes());
        runContext.stateStore().putState(state, null, "b-taskrun-value", "0b-value".getBytes());
        runContext.stateStore().putState(state, "a-name", null, "a0-value".getBytes());
        runContext.stateStore().putState(state, "b-name", null, "b0-value".getBytes());
        Assertions.assertThat((byte[])runContext.stateStore().getState(state, "a-name", "a-taskrun-value").readAllBytes()).isEqualTo((Object)"aa-value".getBytes());
        Assertions.assertThat((byte[])runContext.stateStore().getState(state, "a-name", "b-taskrun-value").readAllBytes()).isEqualTo((Object)"ab-value".getBytes());
        Assertions.assertThat((byte[])runContext.stateStore().getState(state, "b-name", "a-taskrun-value").readAllBytes()).isEqualTo((Object)"ba-value".getBytes());
        Assertions.assertThat((byte[])runContext.stateStore().getState(state, "b-name", "b-taskrun-value").readAllBytes()).isEqualTo((Object)"bb-value".getBytes());
        Assertions.assertThat((byte[])runContext.stateStore().getState(state, null, "a-taskrun-value").readAllBytes()).isEqualTo((Object)"0a-value".getBytes());
        Assertions.assertThat((byte[])runContext.stateStore().getState(state, null, "b-taskrun-value").readAllBytes()).isEqualTo((Object)"0b-value".getBytes());
        Assertions.assertThat((byte[])runContext.stateStore().getState(state, "a-name", null).readAllBytes()).isEqualTo((Object)"a0-value".getBytes());
        Assertions.assertThat((byte[])runContext.stateStore().getState(state, "b-name", null).readAllBytes()).isEqualTo((Object)"b0-value".getBytes());
    }

    private RunContext runContext() {
        return TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)((Log.LogBuilder)((Log.LogBuilder)Log.builder().id("log")).type(Log.class.getName())).message((Object)"logging").build(), null);
    }
}

