/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.storages.StorageContext;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StorageContextTest {
    StorageContextTest() {
    }

    @Test
    void shouldGetValidUriForFlowContext() {
        StorageContext context = StorageContext.forExecution((Execution)Execution.builder().tenantId("tenantId").id("executionid").namespace("namespace").flowId("flowid").build());
        Assertions.assertThat((URI)context.getFlowStorageURI()).isEqualTo((Object)URI.create("///namespace/flowid"));
    }

    @Test
    void shouldGetValidUriForExecutionContext() {
        StorageContext context = StorageContext.forExecution((Execution)Execution.builder().tenantId("tenantId").id("executionid").namespace("namespace").flowId("flowid").build());
        Assertions.assertThat((URI)context.getExecutionStorageURI()).isEqualTo((Object)URI.create("///namespace/flowid/executions/executionid"));
        Assertions.assertThat((URI)context.getContextStorageURI()).isEqualTo((Object)URI.create("///namespace/flowid/executions/executionid"));
    }

    @Test
    void shouldGetValidUriForExecutionContextWithScheme() {
        StorageContext context = StorageContext.forExecution((Execution)Execution.builder().tenantId("tenantId").id("executionid").namespace("namespace").flowId("flowid").build());
        Assertions.assertThat((URI)context.getExecutionStorageURI("kestra")).isEqualTo((Object)URI.create("kestra:///namespace/flowid/executions/executionid"));
        Assertions.assertThat((URI)context.getExecutionStorageURI("kestra://")).isEqualTo((Object)URI.create("kestra:///namespace/flowid/executions/executionid"));
        Assertions.assertThat((URI)context.getContextStorageURI()).isEqualTo((Object)URI.create("///namespace/flowid/executions/executionid"));
    }

    @Test
    void shouldGetValidURIForTaskContext() {
        StorageContext.Task context = StorageContext.forTask((String)"???", (String)"namespace", (String)"flowid", (String)"executionid", (String)"taskid", (String)"taskrun", null);
        Assertions.assertThat((URI)context.getExecutionStorageURI()).isEqualTo((Object)URI.create("///namespace/flowid/executions/executionid"));
        Assertions.assertThat((URI)context.getContextStorageURI()).isEqualTo((Object)URI.create("///namespace/flowid/executions/executionid/tasks/taskid/taskrun"));
    }

    @Test
    void shouldGetValidURIForTriggerContext() {
        StorageContext.Trigger context = StorageContext.forTrigger((String)"???", (String)"namespace", (String)"flowid", (String)"executionid", (String)"triggerid");
        Assertions.assertThat((URI)context.getExecutionStorageURI()).isEqualTo((Object)URI.create("///namespace/flowid/executions/executionid"));
        Assertions.assertThat((URI)context.getContextStorageURI()).isEqualTo((Object)URI.create("///namespace/flowid/executions/executionid/trigger/triggerid"));
    }

    @Test
    void shouldGetNamespaceFilePrefix() {
        Assertions.assertThat((String)StorageContext.namespaceFilePrefix((String)"io.namespace")).isEqualTo("/io/namespace/_files");
    }

    @Test
    void shouldGetTaskCachePrefix() {
        Assertions.assertThat((URI)StorageContext.forFlow((FlowId)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().tenantId(null)).namespace("namespace")).id("flowid")).build()).getCacheURI("taskid", null)).isEqualTo((Object)URI.create("/namespace/flowid/taskid/cache/cache.zip"));
        Assertions.assertThat((URI)StorageContext.forFlow((FlowId)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().tenantId(null)).namespace("namespace")).id("flowid")).build()).getCacheURI("taskid", "value")).isEqualTo((Object)URI.create("/namespace/flowid/taskid/cache/7d04fd3bbbc0946dc06caf7356fdf051/cache.zip"));
    }
}

