/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.exceptions.KestraRuntimeException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.storages.StorageInterfaceFactory;
import io.kestra.storage.local.LocalStorage;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class StorageInterfaceFactoryTest {
    @Inject
    StorageInterfaceFactory storageInterfaceFactory;

    StorageInterfaceFactoryTest() {
    }

    @Test
    void shouldReturnStorageGivenValidId() {
        StorageInterface storage = this.storageInterfaceFactory.make(null, "local", Map.of("basePath", "/tmp/kestra"));
        Assertions.assertNotNull((Object)storage);
        Assertions.assertEquals((Object)LocalStorage.class.getName(), (Object)storage.getType());
    }

    @Test
    void shouldFailedGivenInvalidId() {
        Assertions.assertThrows(KestraRuntimeException.class, () -> this.storageInterfaceFactory.make(null, "invalid", Map.of()));
    }

    @Test
    void shouldFailedGivenInvalidConfig() {
        KestraRuntimeException e = (KestraRuntimeException)Assertions.assertThrows(KestraRuntimeException.class, () -> this.storageInterfaceFactory.make(null, "local", Map.of()));
        Assertions.assertTrue((boolean)(e.getCause() instanceof ConstraintViolationException));
        Assertions.assertEquals((Object)"basePath: must not be null", (Object)e.getCause().getMessage());
    }

    @Test
    void should_not_found_unknown_storage() {
        KestraRuntimeException e = (KestraRuntimeException)Assertions.assertThrows(KestraRuntimeException.class, () -> this.storageInterfaceFactory.make(null, "unknown", Map.of()));
        Assertions.assertEquals((Object)"No storage interface can be found for 'kestra.storage.type=unknown'. Supported types are: [local]", (Object)e.getMessage());
    }
}

