/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class FetchTest {
    FetchTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/get-log.yaml")
    void fetch(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
        TaskRun fetch = (TaskRun)execution.findTaskRunsByTaskId("get-log-task").getFirst();
        Assertions.assertThat((Object)fetch.getOutputs().get((Object)"size")).isEqualTo((Object)3);
    }

    @Test
    @ExecuteFlow(value="flows/valids/get-log-taskid.yaml")
    void fetchWithTaskId(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
        TaskRun fetch = (TaskRun)execution.findTaskRunsByTaskId("get-log-task").getFirst();
        Assertions.assertThat((Object)fetch.getOutputs().get((Object)"size")).isEqualTo((Object)1);
    }

    @Test
    @ExecuteFlow(value="flows/valids/get-log-executionid.yaml")
    void fetchWithExecutionId(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
        TaskRun fetch = (TaskRun)execution.findTaskRunsByTaskId("get-log-task").getFirst();
        Assertions.assertThat((Object)fetch.getOutputs().get((Object)"size")).isEqualTo((Object)3);
    }
}

