/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.Variables;
import io.kestra.core.models.flows.State;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class OutputValuesTest {
    OutputValuesTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/output-values.yml")
    void output(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        TaskRun outputValues = (TaskRun)execution.getTaskRunList().getFirst();
        Assertions.assertThat((Map)outputValues.getOutputs()).isInstanceOf(Variables.InMemoryVariables.class);
        Map values = (Map)outputValues.getOutputs().get((Object)"values");
        Assertions.assertThat(values.get("output1")).isEqualTo((Object)"xyz");
        Assertions.assertThat(values.get("output2")).isEqualTo((Object)"abc");
        outputValues = (TaskRun)execution.getTaskRunList().getLast();
        Assertions.assertThat((Map)outputValues.getOutputs()).isInstanceOf(Variables.InMemoryVariables.class);
        values = (Map)outputValues.getOutputs().get((Object)"values");
        Assertions.assertThat(values.get("output1")).isEqualTo((Object)"xyz");
        Assertions.assertThat(values.get("output2")).isEqualTo((Object)"abc");
    }
}

