/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.tasks.runners.PluginUtilsService;
import io.kestra.core.runners.RunContext;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class PluginUtilsServiceTest {
    @Inject
    private TestRunContextFactory runContextFactory;

    @Test
    void outputFiles() throws IOException {
        Path tempDirectory = Files.createTempDirectory("plugin-utils", new FileAttribute[0]);
        Map outputFilesMap = PluginUtilsService.createOutputFiles((Path)tempDirectory, List.of("out"), new HashMap<String, String>(Map.of("workingDir", tempDirectory.toAbsolutePath().toString())));
        Assertions.assertThat((String)((String)outputFilesMap.get("out"))).startsWith((CharSequence)tempDirectory.resolve("out_").toString());
    }

    @Test
    void executionFromTaskParameters() throws IllegalVariableEvaluationException {
        Map<String, Map<String, String>> variables = Map.of("flow", Map.of("namespace", "namespace", "id", "flow", "revision", 1), "execution", Map.of("id", "execution"));
        RunContext runContext = this.runContextFactory.of(variables);
        PluginUtilsService.ExecutionInfo executionInfo = PluginUtilsService.executionFromTaskParameters((RunContext)runContext, null, null, null);
        Assertions.assertThat((String)executionInfo.namespace()).isEqualTo("namespace");
        Assertions.assertThat((String)executionInfo.flowId()).isEqualTo("flow");
        Assertions.assertThat((String)executionInfo.id()).isEqualTo("execution");
        executionInfo = PluginUtilsService.executionFromTaskParameters((RunContext)runContext, null, null, (String)"exec2");
        Assertions.assertThat((String)executionInfo.namespace()).isEqualTo("namespace");
        Assertions.assertThat((String)executionInfo.flowId()).isEqualTo("flow");
        Assertions.assertThat((String)executionInfo.id()).isEqualTo("exec2");
        executionInfo = PluginUtilsService.executionFromTaskParameters((RunContext)runContext, (String)"ns2", (String)"flow2", (String)"exec2");
        Assertions.assertThat((String)executionInfo.namespace()).isEqualTo("ns2");
        Assertions.assertThat((String)executionInfo.flowId()).isEqualTo("flow2");
        Assertions.assertThat((String)executionInfo.id()).isEqualTo("exec2");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> PluginUtilsService.executionFromTaskParameters((RunContext)runContext, (String)"ns2", (String)"flow2", null));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> PluginUtilsService.executionFromTaskParameters((RunContext)runContext, (String)"ns2", null, (String)"exec2"));
    }
}

