/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.test;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.common.EncryptedString;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import lombok.Generated;

@Schema(title="Debugging task that returns an encrypted value.")
@Plugin(examples={@Example(code={"format: \"Hello World\""})})
public class Encrypted
extends Task
implements RunnableTask<Output> {
    @Schema(title="The templated string to encrypt.")
    @PluginProperty(dynamic=true)
    private String format;

    public Output run(RunContext runContext) throws Exception {
        return Output.builder().value(EncryptedString.from((String)this.format, (RunContext)runContext)).build();
    }

    @Generated
    protected Encrypted(EncryptedBuilder<?, ?> b) {
        super(b);
        this.format = b.format;
    }

    @Generated
    public static EncryptedBuilder<?, ?> builder() {
        return new EncryptedBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Encrypted(super=" + super.toString() + ", format=" + this.getFormat() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Encrypted)) {
            return false;
        }
        Encrypted other = (Encrypted)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Encrypted;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public Encrypted() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The encrypted string.")
        private EncryptedString value;

        @ConstructorProperties(value={"value"})
        @Generated
        Output(EncryptedString value) {
            this.value = value;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public EncryptedString getValue() {
            return this.value;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private EncryptedString value;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder value(EncryptedString value) {
                this.value = value;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.value);
            }

            @Generated
            public String toString() {
                return "Encrypted.Output.OutputBuilder(value=" + String.valueOf(this.value) + ")";
            }
        }
    }

    @Generated
    public static abstract class EncryptedBuilder<C extends Encrypted, B extends EncryptedBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String format;

        @Generated
        public B format(String format) {
            this.format = format;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Encrypted.EncryptedBuilder(super=" + super.toString() + ", format=" + this.format + ")";
        }
    }

    @Generated
    private static final class EncryptedBuilderImpl
    extends EncryptedBuilder<Encrypted, EncryptedBuilderImpl> {
        @Generated
        private EncryptedBuilderImpl() {
        }

        @Override
        @Generated
        protected EncryptedBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Encrypted build() {
            return new Encrypted(this);
        }
    }
}

