/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.test;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerService;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;

public class PollingTrigger
extends AbstractTrigger
implements PollingTriggerInterface {
    @PluginProperty
    @NotNull
    private Long duration;

    public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws IllegalVariableEvaluationException {
        try {
            Thread.sleep(this.duration);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Execution execution = TriggerService.generateExecution((AbstractTrigger)this, (ConditionContext)conditionContext, (TriggerContext)context, Collections.emptyMap());
        return Optional.of(execution);
    }

    public Duration getInterval() {
        return Duration.of(1L, ChronoUnit.MINUTES);
    }

    @Generated
    private static Long $default$duration() {
        return 1000L;
    }

    @Generated
    protected PollingTrigger(PollingTriggerBuilder<?, ?> b) {
        super(b);
        this.duration = b.duration$set ? b.duration$value : PollingTrigger.$default$duration();
    }

    @Generated
    public static PollingTriggerBuilder<?, ?> builder() {
        return new PollingTriggerBuilderImpl();
    }

    @Generated
    public PollingTrigger() {
        this.duration = PollingTrigger.$default$duration();
    }

    @Generated
    public static abstract class PollingTriggerBuilder<C extends PollingTrigger, B extends PollingTriggerBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private boolean duration$set;
        @Generated
        private Long duration$value;

        @Generated
        public B duration(Long duration) {
            this.duration$value = duration;
            this.duration$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PollingTrigger.PollingTriggerBuilder(super=" + super.toString() + ", duration$value=" + this.duration$value + ")";
        }
    }

    @Generated
    private static final class PollingTriggerBuilderImpl
    extends PollingTriggerBuilder<PollingTrigger, PollingTriggerBuilderImpl> {
        @Generated
        private PollingTriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected PollingTriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PollingTrigger build() {
            return new PollingTrigger(this);
        }
    }
}

