/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.test;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.FlakyTest;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class SanityCheckTest {
    SanityCheckTest() {
    }

    @Test
    @ExecuteFlow(value="sanity-checks/fail.yaml")
    void qaFail(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/fetch.yaml")
    void qaFetch(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/if.yaml")
    void qaIf(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @FlakyTest
    @Test
    @ExecuteFlow(value="sanity-checks/kv.yaml")
    void qaKv(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/labels.yaml")
    void qaLabels(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/namespace_files.yaml")
    void qaNamespaceFiles(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/parallel.yaml")
    void qaParallel(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/pause-test.yaml")
    void qaPause(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/purge_current_execution_files.yaml")
    void qaPurgeExecutionFiles(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/return.yaml")
    void qaReturn(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TaskRun taskRun = (TaskRun)execution.findTaskRunsByTaskId("return_value").getFirst();
        Assertions.assertThat((Object)taskRun.getOutputs().get((Object)"value")).isEqualTo((Object)"some string with pebble test");
    }

    @Test
    @ExecuteFlow(value="sanity-checks/sequential.yaml")
    void qaSequential(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/switch.yaml")
    void qaSwitch(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/write.yaml")
    void qaWrite(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/purge_kv.yaml")
    void qaPurgeKv(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="sanity-checks/output_values.yaml")
    void qaOutputValues(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

