/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.test;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.test.flow.Assertion;
import io.kestra.core.test.flow.AssertionResult;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

@KestraTest
class AssertionTest {
    @Inject
    RunContextFactory runContextFactory;

    AssertionTest() {
    }

    @Test
    void shouldAssertSuccess_equalTo() {
        Assertion assertion = Assertion.builder().value(Property.ofValue((Object)"value1")).equalTo(Property.ofValue((Object)"value1")).description(Property.ofValue((Object)"my description")).build();
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)assertion.run(this.runContextFactory.of()).results()).hasSize(1)).first()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((Object)result).extracting(AssertionResult::isSuccess).isEqualTo((Object)true);
            Assertions.assertThat((Object)result).extracting(AssertionResult::description).isEqualTo((Object)"my description");
            Assertions.assertThat((Object)result).extracting(AssertionResult::errorMessage).isNull();
        }});
    }

    @Test
    void shouldAssertFail_equalTo() {
        Assertion assertion = Assertion.builder().value(Property.ofValue((Object)"value1")).equalTo(Property.ofValue((Object)"different-value")).errorMessage(Property.ofValue((Object)"error message")).build();
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)assertion.run(this.runContextFactory.of()).results()).hasSize(1)).first()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((Object)result).extracting(AssertionResult::isSuccess).isEqualTo((Object)false);
            Assertions.assertThat((Object)result).extracting(AssertionResult::errorMessage).isEqualTo((Object)"error message");
        }});
    }

    @Test
    void shouldBrokenAssert_returnError() {
        Assertion assertion = Assertion.builder().value(Property.ofExpression((String)"{{ invalid-pebble-expression() }}")).equalTo(Property.ofValue((Object)"value")).build();
        Assertions.assertThat((List)assertion.run(this.runContextFactory.of()).results()).hasSize(0);
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)assertion.run(this.runContextFactory.of()).errors()).hasSize(1)).first()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((String)result.message()).contains(new CharSequence[]{"Could not evaluate assertion"});
            Assertions.assertThat((String)result.details()).contains(new CharSequence[]{"invalid-pebble-expression()"});
            Assertions.assertThat((String)result.details()).contains(new CharSequence[]{"io.pebbletemplates.pebble.error.PebbleException"});
        }});
    }

    @Test
    void shouldRender_values_fromTaskOutputs() {
        Assertion assertion = Assertion.builder().value(Property.ofExpression((String)"{{ outputs.my_task.res }}")).equalTo(Property.ofValue((Object)"value1")).build();
        RunContext runContext = this.runContextFactory.of(Map.of("outputs", Map.of("my_task", Map.of("res", "value1"))));
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)assertion.run(runContext).results()).hasSize(1)).first()).extracting(AssertionResult::isSuccess).isEqualTo((Object)true);
    }

    @Test
    void shouldRender_values_fromTaskOutputs_and_produce_defaultErrorMessage() {
        Assertion assertion = Assertion.builder().value(Property.ofExpression((String)"{{ outputs.my_task.res }}")).equalTo(Property.ofValue((Object)"expectedValue2")).build();
        RunContext runContext = this.runContextFactory.of(Map.of("outputs", Map.of("my_task", Map.of("res", "actualValue1"))));
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)assertion.run(runContext).results()).hasSize(1)).first()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((Object)result).extracting(AssertionResult::isSuccess).isEqualTo((Object)false);
            Assertions.assertThat((Object)result).extracting(AssertionResult::errorMessage).isEqualTo((Object)"expected '{{ outputs.my_task.res }}' to equal 'expectedValue2' but was 'actualValue1'");
        }});
    }

    @Test
    void endsWith_success_number() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)1)).equalTo(Property.ofValue((Object)1)).build());
    }

    @Test
    void equalTo_failure_number() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)1)).equalTo(Property.ofValue((Object)2)).build());
    }

    @Test
    void endsWith_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)"mystring")).endsWith(Property.ofValue((Object)"ing")).build());
    }

    @Test
    void endsWith_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)"mystring")).endsWith(Property.ofValue((Object)"mys")).build());
    }

    @Test
    void startsWith_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)"mystring")).startsWith(Property.ofValue((Object)"mys")).build());
    }

    @Test
    void startsWith_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)"mystring")).startsWith(Property.ofValue((Object)"ing")).build());
    }

    @Test
    void contains_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)"mystring")).contains(Property.ofValue((Object)"str")).build());
    }

    @Test
    void contains_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)"mystring")).contains(Property.ofValue((Object)"toto")).build());
    }

    @Test
    void notEqualTo_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)"value1")).notEqualTo(Property.ofValue((Object)"value2222")).build());
    }

    @Test
    void notEqualTo_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)"value1")).notEqualTo(Property.ofValue((Object)"value1")).build());
    }

    @Test
    void greaterThan_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)333.0)).greaterThan(Property.ofValue((Object)2.0)).build());
    }

    @Test
    void greaterThan_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)2.0)).greaterThan(Property.ofValue((Object)333.0)).build());
    }

    @Test
    void greaterThanOrEqualTo_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)333.0)).greaterThanOrEqualTo(Property.ofValue((Object)333.0)).build());
    }

    @Test
    void greaterThanOrEqualTo_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)2.0)).greaterThanOrEqualTo(Property.ofValue((Object)333.0)).build());
    }

    @Test
    void lessThan_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)2.0)).lessThan(Property.ofValue((Object)444.0)).build());
    }

    @Test
    void lessThan_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)444.0)).lessThan(Property.ofValue((Object)2.0)).build());
    }

    @Test
    void lessThanOrEqualTo_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)444.0)).lessThanOrEqualTo(Property.ofValue((Object)444.0)).build());
    }

    @Test
    void lessThanOrEqualTo_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)444.0)).lessThanOrEqualTo(Property.ofValue((Object)2.0)).build());
    }

    @Test
    void in_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)"a")).in(Property.ofValue(List.of("a", "b"))).build());
    }

    @Test
    void in_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)"x")).in(Property.ofValue(List.of("a", "b"))).build());
    }

    @Test
    void notIn_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)"a")).notIn(Property.ofValue(List.of("d", "e"))).build());
    }

    @Test
    void notIn_failure() {
        this.testAssertionResultFails(Assertion.builder().value(Property.ofValue((Object)"a")).notIn(Property.ofValue(List.of("a", "b"))).build());
    }

    @Test
    void isNull_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue(null)).isNull(Property.ofValue((Object)true)).build());
    }

    @Test
    void isNull_failure() {
        Assertion testedAssertion = Assertion.builder().value(Property.ofValue((Object)"value1")).isNull(Property.ofValue((Object)true)).build();
        ((ObjectAssert)Assertions.assertThat((List)testedAssertion.run(this.runContextFactory.of()).results()).first()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((Object)result).extracting(AssertionResult::isSuccess).isEqualTo((Object)false);
            Assertions.assertThat((Object)result).extracting(AssertionResult::errorMessage).isEqualTo((Object)"expected 'value1' to be null but was 'value1'");
        }});
    }

    @Test
    void isNotNull_success() {
        this.testAssertionResultSuccess(Assertion.builder().value(Property.ofValue((Object)"value1")).isNotNull(Property.ofValue((Object)true)).build());
    }

    @Test
    void isNotNull_failure() {
        Assertion testedAssertion = Assertion.builder().value(Property.ofValue(null)).isNotNull(Property.ofValue((Object)true)).build();
        ((ObjectAssert)Assertions.assertThat((List)testedAssertion.run(this.runContextFactory.of()).results()).first()).satisfies(new ThrowingConsumer[]{result -> {
            Assertions.assertThat((Object)result).extracting(AssertionResult::isSuccess).isEqualTo((Object)false);
            Assertions.assertThat((Object)result).extracting(AssertionResult::errorMessage).isEqualTo((Object)"expected 'null' to be not null but was 'null'");
        }});
    }

    @Test
    void isNotNull_and_isEqualTo_failure() {
        Assertion testedAssertion = Assertion.builder().value(Property.ofValue((Object)"value1")).isNotNull(Property.ofValue((Object)true)).equalTo(Property.ofValue((Object)"value222")).build();
        List testResults = testedAssertion.run(this.runContextFactory.of()).results();
        Assertions.assertThat((List)testResults).hasSize(2);
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)testResults).filteredOn(res -> res.operator().equals(Assertion.Operator.IS_NOT_NULL.toString()))).first()).extracting(AssertionResult::isSuccess).isEqualTo((Object)true);
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)testResults).filteredOn(res -> res.operator().equals(Assertion.Operator.EQUAL_TO.toString()))).first()).extracting(AssertionResult::isSuccess).isEqualTo((Object)false);
    }

    void testAssertionResultSuccess(Assertion testedAssertion) {
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)testedAssertion.run(this.runContextFactory.of()).results()).hasSize(1)).first()).extracting(AssertionResult::isSuccess).isEqualTo((Object)true);
    }

    void testAssertionResultFails(Assertion testedAssertion) {
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)testedAssertion.run(this.runContextFactory.of()).results()).hasSize(1)).first()).extracting(AssertionResult::isSuccess).isEqualTo((Object)false);
    }
}

