/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.test;

import io.kestra.core.test.TestState;
import io.kestra.core.test.TestSuiteRunResult;
import io.kestra.core.test.flow.AssertionResult;
import io.kestra.core.test.flow.AssertionRunError;
import io.kestra.core.test.flow.UnitTestResult;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class TestSuiteRunResultTest {
    private static final AssertionResult SUCCESSFUL_ASSERTION = new AssertionResult("operator", (Object)"val", (Object)"val", Boolean.valueOf(true), null, null, null);
    private static final AssertionResult FAILING_ASSERTION = new AssertionResult("operator", (Object)"val", (Object)"val", Boolean.valueOf(false), null, null, null);

    TestSuiteRunResultTest() {
    }

    @Test
    void success() {
        TestSuiteRunResult res = TestSuiteRunResult.of((String)"id", (String)"testSuiteId", (String)"namespace", (String)"flowId", (Instant)Instant.now(), (Instant)Instant.now(), List.of(UnitTestResult.of((String)"id", (String)"type", (String)"executionId", (URI)URI.create("url"), List.of(SUCCESSFUL_ASSERTION), List.of(), null)));
        Assertions.assertThat((Object)res).extracting(TestSuiteRunResult::state).isEqualTo((Object)TestState.SUCCESS);
    }

    @Test
    void disabled() {
        TestSuiteRunResult res = TestSuiteRunResult.ofDisabledTestSuite((String)"id", (String)"testSuiteId", (String)"namespace", (String)"flowId");
        Assertions.assertThat((Object)res).extracting(TestSuiteRunResult::state).isEqualTo((Object)TestState.SKIPPED);
    }

    @Test
    void one_assertion_failed() {
        TestSuiteRunResult res = TestSuiteRunResult.of((String)"id", (String)"testSuiteId", (String)"namespace", (String)"flowId", (Instant)Instant.now(), (Instant)Instant.now(), List.of(UnitTestResult.of((String)"id", (String)"type", (String)"executionId", (URI)URI.create("url"), List.of(SUCCESSFUL_ASSERTION, FAILING_ASSERTION, SUCCESSFUL_ASSERTION), List.of(), null)));
        Assertions.assertThat((Object)res).extracting(TestSuiteRunResult::state).isEqualTo((Object)TestState.FAILED);
    }

    @Test
    void one_testcase_failed() {
        TestSuiteRunResult res = TestSuiteRunResult.of((String)"id", (String)"testSuiteId", (String)"namespace", (String)"flowId", (Instant)Instant.now(), (Instant)Instant.now(), List.of(UnitTestResult.of((String)"id", (String)"type", (String)"executionId", (URI)URI.create("url"), List.of(SUCCESSFUL_ASSERTION), List.of(), null), UnitTestResult.of((String)"id", (String)"type", (String)"executionId", (URI)URI.create("url"), List.of(FAILING_ASSERTION), List.of(), null)));
        Assertions.assertThat((Object)res).extracting(TestSuiteRunResult::state).isEqualTo((Object)TestState.FAILED);
    }

    @Test
    void one_testcase_error() {
        TestSuiteRunResult res = TestSuiteRunResult.of((String)"id", (String)"testSuiteId", (String)"namespace", (String)"flowId", (Instant)Instant.now(), (Instant)Instant.now(), List.of(UnitTestResult.of((String)"id", (String)"type", (String)"executionId", (URI)URI.create("url"), List.of(SUCCESSFUL_ASSERTION), List.of(), null), UnitTestResult.of((String)"id", (String)"type", (String)"executionId", (URI)URI.create("url"), List.of(FAILING_ASSERTION), List.of(), null), UnitTestResult.of((String)"id", (String)"type", (String)"executionId", (URI)URI.create("url"), List.of(), List.of(new AssertionRunError("assertion failed", "assertion failed details")), null)));
        Assertions.assertThat((Object)res).extracting(TestSuiteRunResult::state).isEqualTo((Object)TestState.ERROR);
    }

    @Test
    void one_testcase_skipped() {
        String skippedTestcaseId = "skipped_testcase_id";
        TestSuiteRunResult res = TestSuiteRunResult.of((String)"id", (String)"testSuiteId", (String)"namespace", (String)"flowId", (Instant)Instant.now(), (Instant)Instant.now(), List.of(UnitTestResult.of((String)"id", (String)"type", (String)"executionId", (URI)URI.create("url"), List.of(SUCCESSFUL_ASSERTION), List.of(), null), UnitTestResult.ofDisabled((String)skippedTestcaseId, (String)"type", null)));
        Assertions.assertThat((Object)res).extracting(TestSuiteRunResult::state).isEqualTo((Object)TestState.SUCCESS);
        ((ObjectAssert)((ListAssert)Assertions.assertThat((List)res.results()).filteredOn(testcase -> skippedTestcaseId.equals(testcase.testId()))).first()).extracting(UnitTestResult::state).isEqualTo((Object)TestState.SKIPPED);
    }

    @Test
    void all_testcases_skipped() {
        TestSuiteRunResult res = TestSuiteRunResult.of((String)"id", (String)"testSuiteId", (String)"namespace", (String)"flowId", (Instant)Instant.now(), (Instant)Instant.now(), List.of(UnitTestResult.ofDisabled((String)"id", (String)"type", null), UnitTestResult.ofDisabled((String)"id", (String)"type", null)));
        Assertions.assertThat((Object)res).extracting(TestSuiteRunResult::state).isEqualTo((Object)TestState.SKIPPED);
    }

    @Test
    void testcase_skipped() {
        TestSuiteRunResult res = TestSuiteRunResult.of((String)"id", (String)"testSuiteId", (String)"namespace", (String)"flowId", (Instant)Instant.now(), (Instant)Instant.now(), List.of(UnitTestResult.ofDisabled((String)"id", (String)"type", null)));
        Assertions.assertThat((Object)res).extracting(TestSuiteRunResult::state).isEqualTo((Object)TestState.SKIPPED);
    }
}

