/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.test;

import io.kestra.core.serializers.YamlParser;
import io.kestra.core.test.TestSuite;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSuiteTest {
    TestSuiteTest() {
    }

    @Test
    void canBe_parsed() {
        String source = "id: simple-return-test-suite-1-id\nnamespace: io.kestra.tests\ndescription: assert flow is returning the input value as output\nflowId: return-flow\ntestCases:\n  - id: test_case_1\n    type: io.kestra.core.tests.flow.UnitTest\n    fixtures:\n      inputs:\n        inputA: \"Hi there\"\n    assertions:\n      - value: \"{{ outputs.return.value }}\"\n        equalTo: 'Hi there'\n";
        TestSuite parsedTestSuite = ((TestSuite)YamlParser.parse((String)source, TestSuite.class)).toBuilder().source(source).tenantId("main").build();
        Assertions.assertThat((Object)parsedTestSuite).isNotNull();
        Assertions.assertThat((Object)parsedTestSuite).extracting(TestSuite::getId).isEqualTo((Object)"simple-return-test-suite-1-id");
    }

    @Test
    void canBe_disabled() {
        String source = "id: simple-return-test-suite-1-id\nnamespace: io.kestra.tests\ndescription: assert flow is returning the input value as output\nflowId: return-flow\ntestCases:\n  - id: test_case_1\n    type: io.kestra.core.tests.flow.UnitTest\n    fixtures:\n      inputs:\n        inputA: \"Hi there\"\n    assertions:\n      - value: \"{{ outputs.return.value }}\"\n        equalTo: 'Hi there'\n";
        TestSuite parsedTestSuite = ((TestSuite)YamlParser.parse((String)source, TestSuite.class)).toBuilder().source(source).tenantId("main").build();
        parsedTestSuite = parsedTestSuite.disable();
        Assertions.assertThat((Object)parsedTestSuite).extracting(TestSuite::isDisabled).isEqualTo((Object)true);
        Assertions.assertThat((String)parsedTestSuite.getSource()).contains(new CharSequence[]{"disabled: true"});
    }

    @Test
    void canBe_enabled() {
        String source = "id: simple-return-test-suite-1-id\nnamespace: io.kestra.tests\ndescription: assert flow is returning the input value as output\nflowId: return-flow\ndisabled: true\ntestCases:\n  - id: test_case_1\n    type: io.kestra.core.tests.flow.UnitTest\n    fixtures:\n      inputs:\n        inputA: \"Hi there\"\n    assertions:\n      - value: \"{{ outputs.return.value }}\"\n        equalTo: 'Hi there'\n";
        TestSuite parsedTestSuite = ((TestSuite)YamlParser.parse((String)source, TestSuite.class)).toBuilder().source(source).tenantId("main").build();
        parsedTestSuite = parsedTestSuite.enable();
        Assertions.assertThat((Object)parsedTestSuite).extracting(TestSuite::isDisabled).isEqualTo((Object)false);
        Assertions.assertThat((String)parsedTestSuite.getSource()).contains(new CharSequence[]{"disabled: false"});
    }
}

