/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.topologies;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.topologies.FlowRelation;
import io.kestra.core.serializers.YamlParser;
import io.kestra.core.topologies.FlowTopologyService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.ExecutionFlow;
import io.kestra.plugin.core.condition.ExecutionStatus;
import io.kestra.plugin.core.condition.Expression;
import io.kestra.plugin.core.condition.MultipleCondition;
import io.kestra.plugin.core.debug.Return;
import io.kestra.plugin.core.flow.Parallel;
import io.kestra.plugin.core.flow.Subflow;
import io.kestra.plugin.core.trigger.Flow;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class FlowTopologyServiceTest {
    @Inject
    private FlowTopologyService flowTopologyService;

    FlowTopologyServiceTest() {
    }

    @Test
    void flowTask() {
        Flow parent = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.ee")).id("parent")).revision(Integer.valueOf(1))).tasks(List.of(((Parallel.ParallelBuilder)((Parallel.ParallelBuilder)Parallel.builder().id("para")).type(Parallel.class.getName())).tasks(List.of(((Subflow.SubflowBuilder)((Subflow.SubflowBuilder)Subflow.builder().id("launch")).type(Subflow.class.getName())).namespace("io.kestra.ee").flowId("child").build())).build())).build();
        FlowWithSource child = ((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)((FlowWithSource.FlowWithSourceBuilder)FlowWithSource.builder().namespace("io.kestra.ee")).id("child")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask()))).build();
        Assertions.assertThat((Comparable)this.flowTopologyService.isChild(parent, (Flow)child)).isEqualTo((Object)FlowRelation.FLOW_TASK);
    }

    @Test
    void noRelation() {
        Flow parent = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.ee")).id("parent")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).build();
        Flow child = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.ee")).id("child")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).build();
        Assertions.assertThat((Comparable)this.flowTopologyService.isChild(parent, child)).isNull();
    }

    @Test
    void trigger() {
        Flow parent = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.ee")).id("parent")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).build();
        Flow child = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.ee")).id("child")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).triggers(List.of(((Flow.FlowBuilder)((Flow.FlowBuilder)io.kestra.plugin.core.trigger.Flow.builder().type(io.kestra.plugin.core.trigger.Flow.class.getName())).conditions(List.of(ExecutionFlow.builder().namespace(Property.ofValue((Object)"io.kestra.ee")).flowId(Property.ofValue((Object)"parent")).build(), ExecutionStatus.builder().in(Property.ofValue(List.of(State.Type.SUCCESS))).build()))).build())).build();
        Assertions.assertThat((Comparable)this.flowTopologyService.isChild(parent, child)).isEqualTo((Object)FlowRelation.FLOW_TRIGGER);
    }

    @Test
    void multipleCondition() {
        Flow parent = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.ee")).id("parent")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).build();
        Flow noTrigger = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.exclude")).id("no")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).build();
        Flow child = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.ee")).id("child")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).triggers(List.of(((Flow.FlowBuilder)((Flow.FlowBuilder)io.kestra.plugin.core.trigger.Flow.builder().type(io.kestra.plugin.core.trigger.Flow.class.getName())).conditions(List.of(((ExecutionStatus.ExecutionStatusBuilder)ExecutionStatus.builder().in(Property.ofValue(List.of(State.Type.SUCCESS))).type(ExecutionStatus.class.getName())).build(), ((MultipleCondition.MultipleConditionBuilder)MultipleCondition.builder().type(MultipleCondition.class.getName())).conditions(Map.of("first", ExecutionFlow.builder().namespace(Property.ofValue((Object)"io.kestra.ee")).flowId(Property.ofValue((Object)"parent")).build(), "second", ExecutionFlow.builder().namespace(Property.ofValue((Object)"io.kestra.others")).flowId(Property.ofValue((Object)"invalid")).build(), "filtered", ExecutionStatus.builder().in(Property.ofValue(List.of(State.Type.SUCCESS))).build(), "variables", Expression.builder().expression(Property.ofExpression((String)"{{ true }}")).build())).build()))).build())).build();
        Assertions.assertThat((Comparable)this.flowTopologyService.isChild(parent, child)).isEqualTo((Object)FlowRelation.FLOW_TRIGGER);
        Assertions.assertThat((Comparable)this.flowTopologyService.isChild(noTrigger, child)).isNull();
    }

    @Test
    void preconditions() {
        Flow parent = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.ee")).id("parent")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).build();
        Flow noTrigger = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.exclude")).id("no")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).build();
        Flow child = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.ee")).id("child")).revision(Integer.valueOf(1))).tasks(List.of(this.returnTask())).triggers(List.of(((Flow.FlowBuilder)io.kestra.plugin.core.trigger.Flow.builder().type(io.kestra.plugin.core.trigger.Flow.class.getName())).preconditions(Flow.Preconditions.builder().flows(List.of(Flow.UpstreamFlow.builder().namespace("io.kestra.ee").flowId("parent").build(), Flow.UpstreamFlow.builder().namespace("io.kestra.others").flowId("invalid").build())).where(List.of(Flow.ExecutionFilter.builder().filters(List.of(Flow.Filter.builder().field(Flow.Field.EXPRESSION).type(Flow.Type.IS_NOT_NULL).value("something").build())).build())).build()).build())).build();
        Assertions.assertThat((Comparable)this.flowTopologyService.isChild(parent, child)).isEqualTo((Object)FlowRelation.FLOW_TRIGGER);
        Assertions.assertThat((Comparable)this.flowTopologyService.isChild(noTrigger, child)).isNull();
    }

    @Test
    void self1() throws IOException {
        Flow flow = ((Flow.FlowBuilder)this.parse("flows/valids/trigger-multiplecondition-listener.yaml").toBuilder().revision(Integer.valueOf(1))).build();
        Assertions.assertThat((Comparable)this.flowTopologyService.isChild(flow, flow)).isNull();
    }

    @Test
    void self() throws IOException {
        Flow flow = ((Flow.FlowBuilder)this.parse("flows/valids/trigger-flow-listener.yaml").toBuilder().revision(Integer.valueOf(1))).build();
        Assertions.assertThat((Comparable)this.flowTopologyService.isChild(flow, flow)).isNull();
    }

    private Return returnTask() {
        return ((Return.ReturnBuilder)((Return.ReturnBuilder)Return.builder().id("return")).type(Return.class.getName())).format(Property.ofValue((Object)"ok")).build();
    }

    private Flow parse(String path) throws IOException {
        URL resource = TestsUtils.class.getClassLoader().getResource(path);
        assert (resource != null);
        File file = new File(resource.getFile());
        return (Flow)YamlParser.parse((String)Files.readString(file.toPath()), Flow.class);
    }
}

