/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.topologies;

import io.kestra.core.exceptions.FlowProcessingException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.topologies.FlowTopology;
import io.kestra.core.repositories.FlowTopologyRepositoryInterface;
import io.kestra.core.services.FlowService;
import io.kestra.core.topologies.FlowTopologyService;
import io.kestra.core.utils.IdUtils;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;

@KestraTest
public class FlowTopologyTest {
    @Inject
    private FlowService flowService;
    @Inject
    private FlowTopologyService flowTopologyService;
    @Inject
    private FlowTopologyRepositoryInterface flowTopologyRepository;

    @Test
    void should_findDependencies_simpleCase() throws FlowProcessingException {
        String tenantId = FlowTopologyTest.randomTenantId();
        FlowWithSource child = this.flowService.importFlow(tenantId, "id: child\nnamespace: io.kestra.unittest\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\n");
        FlowWithSource parent = this.flowService.importFlow(tenantId, "id: parent\nnamespace: io.kestra.unittest\ntasks:\n  - id: subflow\n    type: io.kestra.core.tasks.flows.Flow\n    flowId: child\n    namespace: io.kestra.unittest\n");
        FlowWithSource unrelatedFlow = this.flowService.importFlow(tenantId, "id: unrelated_flow\nnamespace: io.kestra.unittest\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\n");
        this.computeAndSaveTopologies(List.of(child, parent, unrelatedFlow));
        System.out.println();
        this.flowTopologyRepository.findAll(tenantId).forEach(topology -> System.out.println(FlowTopologyTestData.of(topology)));
        Stream dependencies = this.flowService.findDependencies(tenantId, "io.kestra.unittest", parent.getId(), false, true);
        this.flowTopologyRepository.findAll(tenantId).forEach(topology -> System.out.println(FlowTopologyTestData.of(topology)));
        Assertions.assertThat(dependencies.map(FlowTopologyTestData::of)).containsExactlyInAnyOrder((Object[])new FlowTopologyTestData[]{new FlowTopologyTestData(parent, child)});
    }

    @Test
    void should_findDependencies_subchildAndSuperParent() throws FlowProcessingException {
        String tenantId = FlowTopologyTest.randomTenantId();
        FlowWithSource subChild = this.flowService.importFlow(tenantId, "id: sub_child\nnamespace: io.kestra.unittest\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\n");
        FlowWithSource child = this.flowService.importFlow(tenantId, "id: child\nnamespace: io.kestra.unittest\ntasks:\n  - id: subflow\n    type: io.kestra.core.tasks.flows.Flow\n    flowId: sub_child\n    namespace: io.kestra.unittest\n");
        FlowWithSource superParent = this.flowService.importFlow(tenantId, "id: super_parent\nnamespace: io.kestra.unittest\ntasks:\n  - id: subflow\n    type: io.kestra.core.tasks.flows.Flow\n    flowId: parent\n    namespace: io.kestra.unittest\n");
        FlowWithSource parent = this.flowService.importFlow(tenantId, "id: parent\nnamespace: io.kestra.unittest\ntasks:\n  - id: subflow\n    type: io.kestra.core.tasks.flows.Flow\n    flowId: child\n    namespace: io.kestra.unittest\n");
        FlowWithSource unrelatedFlow = this.flowService.importFlow(tenantId, "id: unrelated_flow\nnamespace: io.kestra.unittest\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\n");
        this.computeAndSaveTopologies(List.of(subChild, child, superParent, parent, unrelatedFlow));
        System.out.println();
        this.flowTopologyRepository.findAll(tenantId).forEach(topology -> System.out.println(FlowTopologyTestData.of(topology)));
        System.out.println();
        Stream dependencies = this.flowService.findDependencies(tenantId, "io.kestra.unittest", parent.getId(), false, true);
        this.flowTopologyRepository.findAll(tenantId).forEach(topology -> System.out.println(FlowTopologyTestData.of(topology)));
        Assertions.assertThat(dependencies.map(FlowTopologyTestData::of)).containsExactlyInAnyOrder((Object[])new FlowTopologyTestData[]{new FlowTopologyTestData(superParent, parent), new FlowTopologyTestData(parent, child), new FlowTopologyTestData(child, subChild)});
    }

    @Test
    void should_findDependencies_cyclicTriggers() throws FlowProcessingException {
        String tenantId = FlowTopologyTest.randomTenantId();
        FlowWithSource triggeredFlowOne = this.flowService.importFlow(tenantId, "id: triggered_flow_one\nnamespace: io.kestra.unittest\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\ntriggers:\n  - id: listen\n    type: io.kestra.plugin.core.trigger.Flow\n    conditions:\n      - type: io.kestra.plugin.core.condition.ExecutionStatus\n        in:\n          - FAILED\n");
        FlowWithSource triggeredFlowTwo = this.flowService.importFlow(tenantId, "id: triggered_flow_two\nnamespace: io.kestra.unittest\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\ntriggers:\n  - id: listen\n    type: io.kestra.plugin.core.trigger.Flow\n    conditions:\n      - type: io.kestra.plugin.core.condition.ExecutionStatus\n        in:\n          - FAILED\n");
        this.computeAndSaveTopologies(List.of(triggeredFlowOne, triggeredFlowTwo));
        this.flowTopologyRepository.findAll(tenantId).forEach(topology -> System.out.println(FlowTopologyTestData.of(topology)));
        List dependencies = this.flowService.findDependencies(tenantId, "io.kestra.unittest", triggeredFlowTwo.getId(), false, true).toList();
        this.flowTopologyRepository.findAll(tenantId).forEach(topology -> System.out.println(FlowTopologyTestData.of(topology)));
        Assertions.assertThat(dependencies.stream().map(FlowTopologyTestData::of)).containsExactlyInAnyOrder((Object[])new FlowTopologyTestData[]{new FlowTopologyTestData(triggeredFlowTwo, triggeredFlowOne), new FlowTopologyTestData(triggeredFlowOne, triggeredFlowTwo)});
    }

    @Test
    void flowTriggerWithTargetFlow() throws FlowProcessingException {
        String tenantId = FlowTopologyTest.randomTenantId();
        FlowWithSource parent = this.flowService.importFlow(tenantId, "id: parent\nnamespace: io.kestra.unittest\ninputs:\n  - id: a\n    type: BOOL\n    defaults: true\n\n  - id: b\n    type: BOOL\n    defaults: \"{{ inputs.a == true }}\"\n    dependsOn:\n      inputs:\n        - a\ntasks:\n  - id: helloA\n    type: io.kestra.plugin.core.log.Log\n    message: Hello A\n");
        FlowWithSource child = this.flowService.importFlow(tenantId, "id: child\nnamespace: io.kestra.unittest\ntasks:\n  - id: helloB\n    type: io.kestra.plugin.core.log.Log\n    message: Hello B\ntriggers:\n  - id: release\n    type: io.kestra.plugin.core.trigger.Flow\n    states:\n      - SUCCESS\n    preconditions:\n      id: flows\n      flows:\n       - namespace: io.kestra.unittest\n         flowId: parent\n");
        FlowWithSource unrelatedFlow = this.flowService.importFlow(tenantId, "id: unrelated_flow\nnamespace: io.kestra.unittest\ntasks:\n  - id: download\n    type: io.kestra.plugin.core.http.Download\n");
        this.computeAndSaveTopologies(List.of(child, parent, unrelatedFlow));
        System.out.println();
        this.flowTopologyRepository.findAll(tenantId).forEach(topology -> System.out.println(FlowTopologyTestData.of(topology)));
        Stream dependencies = this.flowService.findDependencies(tenantId, "io.kestra.unittest", parent.getId(), false, true);
        this.flowTopologyRepository.findAll(tenantId).forEach(topology -> System.out.println(FlowTopologyTestData.of(topology)));
        Assertions.assertThat(dependencies.map(FlowTopologyTestData::of)).containsExactlyInAnyOrder((Object[])new FlowTopologyTestData[]{new FlowTopologyTestData(parent, child)});
    }

    private void computeAndSaveTopologies(List<@NotNull FlowWithSource> flows) {
        flows.forEach(flow -> this.flowTopologyService.topology(flow, flows).distinct().forEach(topology -> this.flowTopologyRepository.save(topology)));
    }

    private static String randomTenantId() {
        return String.valueOf(FlowTopologyTest.class) + IdUtils.create();
    }

    record FlowTopologyTestData(String sourceUid, String destinationUid) {
        public FlowTopologyTestData(FlowWithSource parent, FlowWithSource child) {
            this(parent.uidWithoutRevision(), child.uidWithoutRevision());
        }

        public static FlowTopologyTestData of(FlowTopology flowTopology) {
            return new FlowTopologyTestData(flowTopology.getSource().getUid(), flowTopology.getDestination().getUid());
        }

        @Override
        public String toString() {
            return this.sourceUid + " -> " + this.destinationUid;
        }
    }
}

