/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.DurationOrSizeTrigger;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DurationOrSizeTriggerTest {
    private final Duration batchDuration = Duration.ofMillis(500L);
    private final DurationOrSizeTrigger<String> trigger = new DurationOrSizeTrigger(this.batchDuration, 100);

    @Test
    public void testBySize() {
        HashMap<String, String> map = this.generateHashMap(99);
        Assertions.assertFalse((boolean)this.trigger.test(map.values()));
        map.put("test", "b");
        Assertions.assertTrue((boolean)this.trigger.test(map.values()));
    }

    @Test
    public void testByDuration() throws InterruptedException {
        HashMap<String, String> map = this.generateHashMap(10);
        Assertions.assertFalse((boolean)this.trigger.test(map.values()));
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)this.trigger.test(map.values()));
        Thread.sleep(500L);
        Assertions.assertTrue((boolean)this.trigger.test(map.values()));
    }

    @Test
    public void testByDurationAndSize() throws InterruptedException {
        Instant next = this.trigger.getNext();
        Assertions.assertTrue((boolean)this.trigger.test(this.generateHashMap(100).values()));
        Thread.sleep(500L);
        Assertions.assertTrue((boolean)this.trigger.test(this.generateHashMap(1).values()));
        Assertions.assertEquals((Object)next.plus(this.batchDuration), (Object)this.trigger.getNext());
    }

    private HashMap<String, String> generateHashMap(int count) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            map.put("" + i, "b");
        }
        return map;
    }
}

