/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.Either;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EitherTest {
    EitherTest() {
    }

    @Test
    void shouldCreateLeftInstance() {
        String leftValue = "error";
        Either either = Either.left((Object)leftValue);
        Assertions.assertThat((Object)either).isInstanceOf(Either.Left.class);
        Assertions.assertThat((boolean)either.isLeft()).isTrue();
        Assertions.assertThat((boolean)either.isRight()).isFalse();
        Assertions.assertThat((String)((String)either.getLeft())).isEqualTo(leftValue);
    }

    @Test
    void shouldCreateRightInstance() {
        Integer rightValue = 42;
        Either either = Either.right((Object)rightValue);
        Assertions.assertThat((Object)either).isInstanceOf(Either.Right.class);
        Assertions.assertThat((boolean)either.isRight()).isTrue();
        Assertions.assertThat((boolean)either.isLeft()).isFalse();
        Assertions.assertThat((Integer)((Integer)either.getRight())).isEqualTo((Object)rightValue);
    }

    @Test
    void shouldCreateLeftWithNullValue() {
        Either either = Either.left(null);
        Assertions.assertThat((boolean)either.isLeft()).isTrue();
        Assertions.assertThat((String)((String)either.getLeft())).isNull();
    }

    @Test
    void shouldCreateRightWithNullValue() {
        Either either = Either.right(null);
        Assertions.assertThat((boolean)either.isRight()).isTrue();
        Assertions.assertThat((Integer)((Integer)either.getRight())).isNull();
    }

    @Test
    void leftShouldReturnCorrectValues() {
        String leftValue = "error message";
        Either either = Either.left((Object)leftValue);
        Assertions.assertThat((boolean)either.isLeft()).isTrue();
        Assertions.assertThat((boolean)either.isRight()).isFalse();
        Assertions.assertThat((String)((String)either.getLeft())).isEqualTo(leftValue);
    }

    @Test
    void leftShouldThrowExceptionWhenGettingRightValue() {
        Either either = Either.left((Object)"error");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Either)either).getRight()).isInstanceOf(NoSuchElementException.class)).hasMessage("This is Left");
    }

    @Test
    void rightShouldReturnCorrectValues() {
        Integer rightValue = 100;
        Either either = Either.right((Object)rightValue);
        Assertions.assertThat((boolean)either.isRight()).isTrue();
        Assertions.assertThat((boolean)either.isLeft()).isFalse();
        Assertions.assertThat((Integer)((Integer)either.getRight())).isEqualTo((Object)rightValue);
    }

    @Test
    void rightShouldThrowExceptionWhenGettingLeftValue() {
        Either either = Either.right((Object)42);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Either)either).getLeft()).isInstanceOf(NoSuchElementException.class)).hasMessage("This is Right");
    }

    @Test
    void shouldApplyLeftFunctionForLeftInstanceInFold() {
        Either either = Either.left((Object)"error");
        Function<String, String> leftFn = s -> "Left: " + s;
        Function<Integer, String> rightFn = i -> "Right: " + i;
        String result = (String)either.fold(leftFn, rightFn);
        Assertions.assertThat((String)result).isEqualTo("Left: error");
    }

    @Test
    void shouldApplyRightFunctionForRightInstanceInFold() {
        Either either = Either.right((Object)42);
        Function<String, String> leftFn = s -> "Left: " + s;
        Function<Integer, String> rightFn = i -> "Right: " + i;
        String result = (String)either.fold(leftFn, rightFn);
        Assertions.assertThat((String)result).isEqualTo("Right: 42");
    }

    @Test
    void shouldHandleNullReturnValuesInFold() {
        Either leftEither = Either.left((Object)"error");
        Either rightEither = Either.right((Object)42);
        String leftResult = (String)leftEither.fold(s -> null, i -> "not null");
        String rightResult = (String)rightEither.fold(s -> "not null", i -> null);
        Assertions.assertThat((String)leftResult).isNull();
        Assertions.assertThat((String)rightResult).isNull();
    }

    @Test
    void leftProjectionShouldExistForLeftInstance() {
        Either either = Either.left((Object)"error");
        Either.LeftProjection projection = either.left();
        Assertions.assertThat((boolean)projection.exists()).isTrue();
        Assertions.assertThat((String)((String)projection.get())).isEqualTo("error");
    }

    @Test
    void leftProjectionShouldNotExistForRightInstance() {
        Either either = Either.right((Object)42);
        Either.LeftProjection projection = either.left();
        Assertions.assertThat((boolean)projection.exists()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Either.LeftProjection)projection).get()).isInstanceOf(NoSuchElementException.class)).hasMessage("This is Right");
    }

    @Test
    void leftProjectionMapShouldTransformLeftValue() {
        Either either = Either.left((Object)"error");
        Either result = either.left().map(String::length);
        Assertions.assertThat((boolean)result.isLeft()).isTrue();
        Assertions.assertThat((Integer)((Integer)result.getLeft())).isEqualTo(5);
    }

    @Test
    void leftProjectionMapShouldPreserveRightValue() {
        Either either = Either.right((Object)42);
        Either result = either.left().map(String::length);
        Assertions.assertThat((boolean)result.isRight()).isTrue();
        Assertions.assertThat((Integer)((Integer)result.getRight())).isEqualTo(42);
    }

    @Test
    void leftProjectionFlatMapShouldTransformLeftValue() {
        Either either = Either.left((Object)"error");
        Either result = either.left().flatMap(s -> Either.left((Object)s.length()));
        Assertions.assertThat((boolean)result.isLeft()).isTrue();
        Assertions.assertThat((Integer)((Integer)result.getLeft())).isEqualTo(5);
    }

    @Test
    void leftProjectionFlatMapShouldPreserveRightValue() {
        Either either = Either.right((Object)42);
        Either result = either.left().flatMap(s -> Either.left((Object)s.length()));
        Assertions.assertThat((boolean)result.isRight()).isTrue();
        Assertions.assertThat((Integer)((Integer)result.getRight())).isEqualTo(42);
    }

    @Test
    void leftProjectionFlatMapCanReturnRight() {
        Either either = Either.left((Object)"error");
        Either result = either.left().flatMap(s -> Either.right((Object)999));
        Assertions.assertThat((boolean)result.isRight()).isTrue();
        Assertions.assertThat((Integer)((Integer)result.getRight())).isEqualTo(999);
    }

    @Test
    void leftProjectionToOptionalShouldReturnPresentForLeft() {
        Either either = Either.left((Object)"error");
        Optional optional = either.left().toOptional();
        Assertions.assertThat((Optional)optional).isPresent();
        Assertions.assertThat((String)((String)optional.get())).isEqualTo("error");
    }

    @Test
    void leftProjectionToOptionalShouldReturnEmptyForRight() {
        Either either = Either.right((Object)42);
        Optional optional = either.left().toOptional();
        Assertions.assertThat((Optional)optional).isEmpty();
    }

    @Test
    void leftProjectionConstructorShouldThrowForNullEither() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Either.LeftProjection(null)).isInstanceOf(NullPointerException.class)).hasMessage("either can't be null");
    }

    @Test
    void rightProjectionShouldExistForRightInstance() {
        Either either = Either.right((Object)42);
        Either.RightProjection projection = either.right();
        Assertions.assertThat((boolean)projection.exists()).isTrue();
        Assertions.assertThat((Integer)((Integer)projection.get())).isEqualTo(42);
    }

    @Test
    void rightProjectionShouldNotExistForLeftInstance() {
        Either either = Either.left((Object)"error");
        Either.RightProjection projection = either.right();
        Assertions.assertThat((boolean)projection.exists()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Either.RightProjection)projection).get()).isInstanceOf(NoSuchElementException.class)).hasMessage("This is Left");
    }

    @Test
    void rightProjectionMapShouldTransformRightValue() {
        Either either = Either.right((Object)42);
        Either result = either.right().map(Object::toString);
        Assertions.assertThat((boolean)result.isRight()).isTrue();
        Assertions.assertThat((String)((String)result.getRight())).isEqualTo("42");
    }

    @Test
    void rightProjectionMapShouldPreserveLeftValue() {
        Either either = Either.left((Object)"error");
        Either result = either.right().map(Object::toString);
        Assertions.assertThat((boolean)result.isLeft()).isTrue();
        Assertions.assertThat((String)((String)result.getLeft())).isEqualTo("error");
    }

    @Test
    void rightProjectionFlatMapShouldTransformRightValue() {
        Either either = Either.right((Object)42);
        Either result = either.right().flatMap(i -> Either.right((Object)i.toString()));
        Assertions.assertThat((boolean)result.isRight()).isTrue();
        Assertions.assertThat((String)((String)result.getRight())).isEqualTo("42");
    }

    @Test
    void rightProjectionFlatMapShouldPreserveLeftValue() {
        Either either = Either.left((Object)"error");
        Either result = either.right().flatMap(i -> Either.right((Object)i.toString()));
        Assertions.assertThat((boolean)result.isLeft()).isTrue();
        Assertions.assertThat((String)((String)result.getLeft())).isEqualTo("error");
    }

    @Test
    void rightProjectionFlatMapCanReturnLeft() {
        Either either = Either.right((Object)42);
        Either result = either.right().flatMap(i -> Either.left((Object)"converted"));
        Assertions.assertThat((boolean)result.isLeft()).isTrue();
        Assertions.assertThat((String)((String)result.getLeft())).isEqualTo("converted");
    }

    @Test
    void rightProjectionToOptionalShouldReturnPresentForRight() {
        Either either = Either.right((Object)42);
        Optional optional = either.right().toOptional();
        Assertions.assertThat((Optional)optional).isPresent();
        Assertions.assertThat((Integer)((Integer)optional.get())).isEqualTo(42);
    }

    @Test
    void rightProjectionToOptionalShouldReturnEmptyForLeft() {
        Either either = Either.left((Object)"error");
        Optional optional = either.right().toOptional();
        Assertions.assertThat((Optional)optional).isEmpty();
    }

    @Test
    void rightProjectionConstructorShouldThrowForNullEither() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Either.RightProjection(null)).isInstanceOf(NullPointerException.class)).hasMessage("either can't be null");
    }

    @Test
    void shouldHandleNullValuesInTransformations() {
        Either leftEither = Either.left(null);
        Either rightEither = Either.right(null);
        Assertions.assertThat((String)((String)leftEither.left().map(s -> s == null ? "was null" : s).getLeft())).isEqualTo("was null");
        Assertions.assertThat((String)((String)rightEither.right().map(i -> i == null ? "was null" : i.toString()).getRight())).isEqualTo("was null");
    }

    @Test
    void shouldHandleComplexTypeTransformations() {
        Either either = Either.right((Object)"hello world");
        Either result = either.left().map(Throwable::getMessage).right().map(String::length);
        Assertions.assertThat((boolean)result.isRight()).isTrue();
        Assertions.assertThat((Integer)((Integer)result.getRight())).isEqualTo(11);
    }

    @Test
    void shouldChainTransformationsCorrectly() {
        Either either = Either.right((Object)10);
        Either result = either.right().flatMap(i -> i > 5 ? Either.right((Object)(i * 2)) : Either.left((Object)"too small")).right().map(i -> "Result: " + i);
        Assertions.assertThat((boolean)result.isRight()).isTrue();
        Assertions.assertThat((String)((String)result.getRight())).isEqualTo("Result: 20");
    }

    @Test
    void shouldHandleProjectionChainingWithErrorCases() {
        Either either = Either.right((Object)3);
        Either result = either.right().flatMap(i -> i > 5 ? Either.right((Object)(i * 2)) : Either.left((Object)"too small")).right().map(i -> "Result: " + i);
        Assertions.assertThat((boolean)result.isLeft()).isTrue();
        Assertions.assertThat((String)((String)result.getLeft())).isEqualTo("too small");
    }
}

