/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.Enums;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnumsTest {
    EnumsTest() {
    }

    @Test
    void shouldGetEnumForNameIgnoreCaseForExisting() {
        TestEnum result = (TestEnum)Enums.getForNameIgnoreCase((String)"enum1", TestEnum.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)TestEnum.ENUM1), (Object)((Object)result));
    }

    @Test
    void shouldGetEnumForNameIgnoreCaseForFallback() {
        TestEnum result = (TestEnum)Enums.getForNameIgnoreCase((String)"LEGACY", TestEnum.class, Map.of("legacy", TestEnum.ENUM2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)TestEnum.ENUM2), (Object)((Object)result));
    }

    @Test
    void shouldThrowExceptionGivenInvalidString() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Enums.getForNameIgnoreCase((String)"invalid", TestEnum.class));
    }

    @Test
    void testFromStringValidMapping() {
        Map<String, TestEnumWithValue> mapping = TestEnumWithValue.getMapping();
        String validValue = "enum1";
        TestEnumWithValue result = (TestEnumWithValue)Enums.fromString((String)validValue, mapping, (String)"TestEnumWithValue");
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)TestEnumWithValue.ENUM1), (Object)((Object)result));
    }

    @Test
    void testFromStringInvalidValue() {
        Map<String, TestEnumWithValue> mapping = TestEnumWithValue.getMapping();
        String invalidValue = "invalidValue";
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Enums.fromString((String)invalidValue, (Map)mapping, (String)"TestEnumWithValue"));
    }

    @Test
    void should_get_from_list() {
        Assertions.assertThat((List)Enums.fromList(List.of(TestEnum.ENUM1, TestEnum.ENUM2), TestEnum.class)).isEqualTo(List.of(TestEnum.ENUM1, TestEnum.ENUM2));
        Assertions.assertThat((List)Enums.fromList(List.of("ENUM1", "ENUM2"), TestEnum.class)).isEqualTo(List.of(TestEnum.ENUM1, TestEnum.ENUM2));
        Assertions.assertThat((List)Enums.fromList((Object)((Object)TestEnum.ENUM1), TestEnum.class)).isEqualTo(List.of(TestEnum.ENUM1));
        Assertions.assertThat((List)Enums.fromList((Object)"ENUM1", TestEnum.class)).isEqualTo(List.of(TestEnum.ENUM1));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Enums.fromList(List.of("string1", "string2"), TestEnum.class));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Enums.fromList((Object)"non enum value", TestEnum.class));
    }

    static enum TestEnum {
        ENUM1,
        ENUM2;

    }

    static enum TestEnumWithValue {
        ENUM1("enum1"),
        ENUM2("enum2");

        private static final Map<String, TestEnumWithValue> BY_VALUE;
        private final String value;

        private TestEnumWithValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Map<String, TestEnumWithValue> getMapping() {
            return BY_VALUE;
        }

        static {
            BY_VALUE = Arrays.stream(TestEnumWithValue.values()).collect(Collectors.toMap(TestEnumWithValue::getValue, Function.identity()));
        }
    }
}

