/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.Exceptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ExceptionsTest {
    ExceptionsTest() {
    }

    @Test
    void shouldGetStacktraceGivenNoMaxLines() {
        String stacktrace = Exceptions.getStacktraceAsString((Throwable)new RuntimeException("boom!"));
        Assertions.assertNotNull((Object)stacktrace);
        Assertions.assertTrue((boolean)stacktrace.startsWith("java.lang.RuntimeException: boom!\n"));
    }

    @Test
    void shouldGetStacktraceGivenMaxLines() {
        String stacktrace = Exceptions.getStacktraceAsString((Throwable)new RuntimeException("boom!"), (int)3);
        Assertions.assertTrue((boolean)stacktrace.startsWith("java.lang.RuntimeException: boom!\n"));
        Assertions.assertEquals((long)4L, (long)stacktrace.lines().count());
    }
}

