/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.IdUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class IdUtilsTest {
    IdUtilsTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"kestra.io", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi eu egestas ligula. Fusce molestie egestas sodales. Morbi ullamcorper nisi sit amet fringilla aliquet. Sed vitae lectus gravida, congue arcu id, accumsan elit. Cras ultrices neque non ex gravida, id faucibus enim aliquet. Phasellus sodales euismod dui non semper. Proin efficitur ac nisi vitae vestibulum. Nullam consequat lectus dui, vulputate molestie turpis commodo quis. Suspendisse sit amet odio facilisis, gravida purus quis, convallis mi. Sed dignissim mi nec sem molestie sagittis. Quisque sollicitudin sed ex ut laoreet. Nunc a bibendum lectus. Fusce volutpat pharetra risus eu auctor."})
    void from(String from) {
        String convert = IdUtils.from((String)from);
        Assertions.assertThat((String)convert).isEqualTo(IdUtils.from((String)from));
    }

    @Test
    void create() {
        String id = IdUtils.create();
        Assertions.assertThat((String)id).isNotNull();
    }

    @Test
    void fromParts() {
        String id = IdUtils.fromParts((String[])new String[]{"namespace", "flow"});
        Assertions.assertThat((String)id).isNotNull();
        Assertions.assertThat((String)id).isEqualTo("namespace_flow");
        String idWithNull = IdUtils.fromParts((String[])new String[]{null, "namespace", "flow"});
        Assertions.assertThat((String)idWithNull).isNotNull();
        Assertions.assertThat((String)idWithNull).isEqualTo("namespace_flow");
    }

    @Test
    void fromPartsAndSeparator() {
        String id = IdUtils.fromPartsAndSeparator((char)'|', (String[])new String[]{"namespace", "flow"});
        Assertions.assertThat((String)id).isNotNull();
        Assertions.assertThat((String)id).isEqualTo("namespace|flow");
        String idWithNull = IdUtils.fromPartsAndSeparator((char)'|', (String[])new String[]{null, "namespace", "flow"});
        Assertions.assertThat((String)idWithNull).isNotNull();
        Assertions.assertThat((String)idWithNull).isEqualTo("namespace|flow");
    }
}

