/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.ListUtils;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ListUtilsTest {
    ListUtilsTest() {
    }

    @Test
    void emptyOnNull() {
        List list = ListUtils.emptyOnNull(null);
        Assertions.assertThat((List)list).isNotNull();
        Assertions.assertThat((List)list).isEmpty();
        list = ListUtils.emptyOnNull(List.of("1"));
        Assertions.assertThat((List)list).isNotNull();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    void isEmpty() {
        Assertions.assertThat((boolean)ListUtils.isEmpty(null)).isTrue();
        Assertions.assertThat((boolean)ListUtils.isEmpty(Collections.emptyList())).isTrue();
        Assertions.assertThat((boolean)ListUtils.isEmpty(List.of("1"))).isFalse();
    }

    @Test
    void concat() {
        List<String> list1 = List.of("1", "2");
        List<String> list2 = List.of("3", "4");
        Assertions.assertThat((List)ListUtils.concat(list1, list2)).isEqualTo(List.of("1", "2", "3", "4"));
        Assertions.assertThat((List)ListUtils.concat(list1, null)).isEqualTo(List.of("1", "2"));
        Assertions.assertThat((List)ListUtils.concat(null, list2)).isEqualTo(List.of("3", "4"));
    }

    @Test
    void convertToList() {
        Assertions.assertThat((List)ListUtils.convertToList(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)))).isEqualTo(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ListUtils.convertToList((Object)"not a list"));
    }

    @Test
    void convertToListString() {
        Assertions.assertThat((List)ListUtils.convertToListString(List.of("string1", "string2"))).isEqualTo(List.of("string1", "string2"));
        Assertions.assertThat((List)ListUtils.convertToListString(List.of())).isEqualTo(List.of());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ListUtils.convertToListString((Object)"not a list"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ListUtils.convertToListString(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))));
    }
}

