/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.MapUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MapUtilsTest {
    MapUtilsTest() {
    }

    @Test
    void merge() {
        Map<String, List<Integer>> a = Map.of("map", Map.of("map_a", "a", "map_b", "b", "map_c", "c"), "string", "a", "int", 1, "lists", Collections.singletonList(1));
        Map<String, List<Integer>> b = Map.of("map", Map.of("map_c", "e", "map_d", "d"), "string", "b", "float", Float.valueOf(1.0f), "lists", Collections.singletonList(2));
        Map merge = MapUtils.merge(a, b);
        Assertions.assertThat((int)((Map)merge.get("map")).size()).isEqualTo(4);
        Assertions.assertThat(((Map)merge.get("map")).get("map_c")).isEqualTo((Object)"e");
        Assertions.assertThat(merge.get("string")).isEqualTo((Object)"b");
        Assertions.assertThat(merge.get("int")).isEqualTo((Object)1);
        Assertions.assertThat(merge.get("float")).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((List)((List)merge.get("lists"))).hasSize(2);
    }

    @Test
    void deepMerge() {
        Map<String, List<Integer>> a = Map.of("map", Map.of("map_a", "a", "map_b", "b", "map_c", "c"), "string", "a", "int", 1, "lists", Collections.singletonList(1));
        Map<String, List<Integer>> b = Map.of("map", Map.of("map_c", "e", "map_d", "d"), "string", "b", "float", Float.valueOf(1.0f), "lists", Collections.singletonList(2));
        Map merge = MapUtils.deepMerge(a, b);
        Assertions.assertThat((int)((Map)merge.get("map")).size()).isEqualTo(4);
        Assertions.assertThat(((Map)merge.get("map")).get("map_c")).isEqualTo((Object)"e");
        Assertions.assertThat(merge.get("string")).isEqualTo((Object)"b");
        Assertions.assertThat(merge.get("int")).isEqualTo((Object)1);
        Assertions.assertThat(merge.get("float")).isEqualTo((Object)Float.valueOf(1.0f));
        Assertions.assertThat((List)((List)merge.get("lists"))).hasSize(2);
    }

    @Test
    void mergeWithNull() {
        HashMap<String, Object> mapWithNull = new HashMap<String, Object>();
        mapWithNull.put("null", null);
        Map<String, Map<String, String>> a = Map.of("map", Map.of("map_a", Map.of("sub", mapWithNull), "map_c", "c"));
        Map<String, Map<String, String>> b = Map.of("map", Map.of("map_c", "e", "map_d", "d"));
        Map merge = MapUtils.merge(a, b);
        Assertions.assertThat((int)((Map)merge.get("map")).size()).isEqualTo(3);
        Assertions.assertThat(((Map)merge.get("map")).get("map_c")).isEqualTo((Object)"e");
        Assertions.assertThat(((Map)((Map)((Map)merge.get("map")).get("map_a")).get("sub")).get("null")).isNull();
    }

    @Test
    void deepMergeWithNull() {
        HashMap<String, Object> mapWithNull = new HashMap<String, Object>();
        mapWithNull.put("null", null);
        Map<String, Map<String, String>> a = Map.of("map", Map.of("map_a", Map.of("sub", mapWithNull), "map_c", "c"));
        Map<String, Map<String, String>> b = Map.of("map", Map.of("map_c", "e", "map_d", "d"));
        Map merge = MapUtils.deepMerge(a, b);
        Assertions.assertThat((int)((Map)merge.get("map")).size()).isEqualTo(3);
        Assertions.assertThat(((Map)merge.get("map")).get("map_c")).isEqualTo((Object)"e");
        Assertions.assertThat(((Map)((Map)((Map)merge.get("map")).get("map_a")).get("sub")).get("null")).isNull();
    }

    @Test
    void shouldMergeWithNullableValuesGivenNullAndDuplicate() {
        Map results = MapUtils.mergeWithNullableValues((Map[])new Map[]{Map.of("k1", "v1", "k2", "v1", "k3", "v1"), Map.of("k1", "v2"), Map.of("k2", "v2"), Map.of("k3", "v2"), new HashMap<String, Object>(){
            {
                this.put("k4", null);
            }
        }});
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)results.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v2", results.get("k1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v2", results.get("k2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"v2", results.get("k3"));
        org.junit.jupiter.api.Assertions.assertNull(results.get("k4"));
    }

    @Test
    void emptyOnNull() {
        Map map = MapUtils.emptyOnNull(null);
        Assertions.assertThat((Map)map).isNotNull();
        Assertions.assertThat((Map)map).isEmpty();
        map = MapUtils.emptyOnNull(Map.of("key", "value"));
        Assertions.assertThat((Map)map).isNotNull();
        Assertions.assertThat((int)map.size()).isEqualTo(1);
    }

    @Test
    void isEmpty() {
        Assertions.assertThat((boolean)MapUtils.isEmpty(null)).isTrue();
        Assertions.assertThat((boolean)MapUtils.isEmpty(Collections.emptyMap())).isTrue();
        Assertions.assertThat((boolean)MapUtils.isEmpty(Map.of("key", "value"))).isFalse();
    }

    @Test
    void shouldReturnMapWhenNestingMapGivenFlattenMap() {
        Map results = MapUtils.flattenToNestedMap(Map.of("k1.k2.k3", "v1", "k1.k2.k4", "v2"));
        org.junit.jupiter.api.Assertions.assertEquals(Map.of("k1", Map.of("k2", Map.of("k3", "v1", "k4", "v2"))), (Object)results);
    }

    @Test
    void shouldReturnMapAndIgnoreConflicts() {
        Map results = MapUtils.flattenToNestedMap(Map.of("k1.k2", "v1", "k1.k2.k3", "v2"));
        Assertions.assertThat((Map)results).hasSize(1);
    }

    @Test
    void shouldFlattenANestedMap() {
        Map results = MapUtils.nestedToFlattenMap(Map.of("k1", Map.of("k2", Map.of("k3", "v1")), "k4", "v2"));
        Assertions.assertThat((Map)results).hasSize(2);
        Assertions.assertThat((Map)results).containsAllEntriesOf(Map.of("k1.k2.k3", "v1", "k4", "v2"));
    }

    @Test
    void shouldFlattenANestedMapWithDuplicateKeys() {
        Map results = MapUtils.nestedToFlattenMap(Map.of("k1", Map.of("k2", Map.of("k3", "v1"), "k4", "v2")));
        Assertions.assertThat((Map)results).hasSize(2);
        Assertions.assertThat((Map)results).containsAllEntriesOf(Map.of("k1.k2.k3", "v1", "k1.k4", "v2"));
    }
}

