/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.NamespaceFiles;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.NamespaceFile;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.NamespaceFilesUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.log.Log;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import reactor.core.publisher.Flux;

@KestraTest
@Execution(value=ExecutionMode.SAME_THREAD)
class NamespaceFilesUtilsTest {
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    StorageInterface storageInterface;
    @Inject
    @Named(value="workerTaskLogQueue")
    QueueInterface<LogEntry> workerTaskLogQueue;
    @Inject
    NamespaceFilesUtils namespaceFilesUtils;

    NamespaceFilesUtilsTest() {
    }

    @Test
    void defaultNs() throws Exception {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.workerTaskLogQueue, either -> logs.add((LogEntry)either.getLeft()));
        Log task = ((Log.LogBuilder)((Log.LogBuilder)Log.builder().id(IdUtils.create())).type(Log.class.getName())).message((Object)"Yo!").build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, Collections.emptyMap());
        String namespace = runContext.flowInfo().namespace();
        ByteArrayInputStream data = new ByteArrayInputStream("a".repeat(1024).getBytes(StandardCharsets.UTF_8));
        for (int i = 0; i < 100; ++i) {
            this.storageInterface.put("main", namespace, this.toNamespacedStorageUri(namespace, URI.create("/" + i + ".txt")), (InputStream)data);
        }
        this.namespaceFilesUtils.loadNamespaceFiles(runContext, NamespaceFiles.builder().build());
        List logEntry = TestsUtils.awaitLogs(logs, (Integer)1);
        receive.blockLast();
        Assertions.assertThat((String)((LogEntry)logEntry.getFirst()).getMessage()).contains(new CharSequence[]{"Loaded 100 namespace files"});
        Assertions.assertThat((Object)runContext.metrics().stream().filter(m -> m.getName().equals("namespacefiles.count")).findFirst().orElseThrow().getValue()).isEqualTo((Object)100.0);
        Assertions.assertThat((Duration)((Duration)runContext.metrics().stream().filter(m -> m.getName().equals("namespacefiles.duration")).findFirst().orElseThrow().getValue())).isInstanceOf(Duration.class);
    }

    @Test
    void customNs() throws Exception {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.workerTaskLogQueue, either -> logs.add((LogEntry)either.getLeft()));
        Log task = ((Log.LogBuilder)((Log.LogBuilder)Log.builder().id(IdUtils.create())).type(Log.class.getName())).message((Object)"Yo!").build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        String namespace = IdUtils.create();
        ByteArrayInputStream data = new ByteArrayInputStream("a".repeat(1024).getBytes(StandardCharsets.UTF_8));
        for (int i = 0; i < 100; ++i) {
            this.storageInterface.put("main", namespace, this.toNamespacedStorageUri(namespace, URI.create("/" + i + ".txt")), (InputStream)data);
        }
        this.namespaceFilesUtils.loadNamespaceFiles(runContext, NamespaceFiles.builder().namespaces(Property.ofValue(List.of(namespace))).build());
        List logEntry = TestsUtils.awaitLogs(logs, (Integer)1);
        receive.blockLast();
        Assertions.assertThat((String)((LogEntry)logEntry.getFirst()).getMessage()).contains(new CharSequence[]{"Loaded 100 namespace files"});
        Assertions.assertThat((Object)runContext.metrics().stream().filter(m -> m.getName().equals("namespacefiles.count")).findFirst().orElseThrow().getValue()).isEqualTo((Object)100.0);
        Assertions.assertThat((Duration)((Duration)runContext.metrics().stream().filter(m -> m.getName().equals("namespacefiles.duration")).findFirst().orElseThrow().getValue())).isInstanceOf(Duration.class);
    }

    @Test
    void multiple_folder_ns() throws Exception {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.workerTaskLogQueue, either -> logs.add((LogEntry)either.getLeft()));
        Log task = ((Log.LogBuilder)((Log.LogBuilder)Log.builder().id(IdUtils.create())).type(Log.class.getName())).message((Object)"Yo!").build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        String namespace = IdUtils.create();
        ByteArrayInputStream data = new ByteArrayInputStream("a".repeat(1024).getBytes(StandardCharsets.UTF_8));
        this.storageInterface.put("main", namespace, this.toNamespacedStorageUri(namespace, URI.create("/folder1/test.txt")), (InputStream)data);
        this.storageInterface.put("main", namespace, this.toNamespacedStorageUri(namespace, URI.create("/folder2/test.txt")), (InputStream)data);
        this.storageInterface.put("main", namespace, this.toNamespacedStorageUri(namespace, URI.create("/test.txt")), (InputStream)data);
        this.namespaceFilesUtils.loadNamespaceFiles(runContext, NamespaceFiles.builder().namespaces(Property.ofValue(List.of(namespace))).build());
        List logEntry = TestsUtils.awaitLogs(logs, (Integer)1);
        receive.blockLast();
        Assertions.assertThat((String)((LogEntry)logEntry.getFirst()).getMessage()).contains(new CharSequence[]{"Loaded 3 namespace files"});
        Assertions.assertThat((Object)runContext.metrics().stream().filter(m -> m.getName().equals("namespacefiles.count")).findFirst().orElseThrow().getValue()).isEqualTo((Object)3.0);
        Assertions.assertThat((Duration)((Duration)runContext.metrics().stream().filter(m -> m.getName().equals("namespacefiles.duration")).findFirst().orElseThrow().getValue())).isInstanceOf(Duration.class);
    }

    @Test
    void multiple_folder_ns_with_folder_per_ns() throws Exception {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.workerTaskLogQueue, either -> logs.add((LogEntry)either.getLeft()));
        Log task = ((Log.LogBuilder)((Log.LogBuilder)Log.builder().id(IdUtils.create())).type(Log.class.getName())).message((Object)"Yo!").build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        String baseNs = IdUtils.create();
        String ns1 = baseNs + ".ns1";
        String ns2 = baseNs + ".ns2";
        ByteArrayInputStream data = new ByteArrayInputStream("a".repeat(1024).getBytes(StandardCharsets.UTF_8));
        this.storageInterface.put("main", ns1, this.toNamespacedStorageUri(ns1, URI.create("/test.txt")), (InputStream)data);
        this.storageInterface.put("main", ns2, this.toNamespacedStorageUri(ns2, URI.create("/test.txt")), (InputStream)data);
        this.namespaceFilesUtils.loadNamespaceFiles(runContext, NamespaceFiles.builder().namespaces(Property.ofValue(List.of(ns1, ns2))).folderPerNamespace(Property.ofValue((Object)true)).build());
        List logEntry = TestsUtils.awaitLogs(logs, (Integer)1);
        receive.blockLast();
        List persistedFiles = runContext.workingDir().findAllFilesMatching(List.of("regex:.*"));
        Assertions.assertThat((int)persistedFiles.size()).isEqualTo(2);
        String stringPaths = persistedFiles.stream().map(Path::toString).collect(Collectors.joining());
        Assertions.assertThat((String)stringPaths).contains(new CharSequence[]{ns1 + "/test.txt"});
        Assertions.assertThat((String)stringPaths).contains(new CharSequence[]{ns2 + "/test.txt"});
        Assertions.assertThat((String)((LogEntry)logEntry.getFirst()).getMessage()).contains(new CharSequence[]{"Loaded 2 namespace files"});
        Assertions.assertThat((Object)runContext.metrics().stream().filter(m -> m.getName().equals("namespacefiles.count")).findFirst().orElseThrow().getValue()).isEqualTo((Object)2.0);
        Assertions.assertThat((Duration)((Duration)runContext.metrics().stream().filter(m -> m.getName().equals("namespacefiles.duration")).findFirst().orElseThrow().getValue())).isInstanceOf(Duration.class);
    }

    private URI toNamespacedStorageUri(String namespace, @Nullable URI relativePath) {
        return NamespaceFile.of((String)namespace, (URI)relativePath).storagePath().toUri();
    }
}

