/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.PathMatcherPredicate;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PathMatcherPredicateTest {
    PathMatcherPredicateTest() {
    }

    @Test
    void shouldSupportGlobExpression() {
        PathMatcherPredicate predicate = PathMatcherPredicate.matches(List.of("glob:**/*"));
        org.junit.jupiter.api.Assertions.assertEquals(List.of("glob:**/*"), (Object)predicate.syntaxAndPatterns());
    }

    @Test
    void shouldSupportRegexExpression() {
        PathMatcherPredicate predicate = PathMatcherPredicate.matches(List.of("regex:.*\\.json"));
        org.junit.jupiter.api.Assertions.assertEquals(List.of("regex:.*\\.json"), (Object)predicate.syntaxAndPatterns());
    }

    @Test
    void shouldAddMissingWildcardToGlobExpressions() {
        PathMatcherPredicate predicate = PathMatcherPredicate.matches(List.of("test.txt"));
        org.junit.jupiter.api.Assertions.assertEquals(List.of("glob:**/test.txt"), (Object)predicate.syntaxAndPatterns());
    }

    @Test
    void shouldUseGlobPatternForExpressionWithNoPrefix() {
        PathMatcherPredicate predicate = PathMatcherPredicate.matches(List.of("**/*"));
        org.junit.jupiter.api.Assertions.assertEquals(List.of("glob:**/*"), (Object)predicate.syntaxAndPatterns());
    }

    @Test
    void shouldAddBasePathForExpressionWithNoPrefix() {
        org.junit.jupiter.api.Assertions.assertEquals(List.of("glob:/sub/dir/**/*"), (Object)PathMatcherPredicate.matches((Path)Path.of("/sub/dir", new String[0]), List.of("**/*")).syntaxAndPatterns());
        org.junit.jupiter.api.Assertions.assertEquals(List.of("glob:/sub/dir/**/*"), (Object)PathMatcherPredicate.matches((Path)Path.of("/sub/dir", new String[0]), List.of("/**/*")).syntaxAndPatterns());
    }

    @Test
    void shouldMatchAllGivenRecursiveGlobExpressionAndNoBasePath() {
        List<Path> paths = Stream.of("/base/test.txt", "/base/sub/dir/test.txt").map(x$0 -> Path.of(x$0, new String[0])).toList();
        PathMatcherPredicate predicate = PathMatcherPredicate.matches(List.of("**/*.txt"));
        List filtered = paths.stream().filter(predicate).toList();
        org.junit.jupiter.api.Assertions.assertEquals(paths, filtered);
    }

    @Test
    void shouldMatchAllGivenSimpleExpressionAndNoBasePath() {
        List<Path> paths = Stream.of("/base/test.txt", "/base/sub/dir/test.txt").map(x$0 -> Path.of(x$0, new String[0])).toList();
        PathMatcherPredicate predicate = PathMatcherPredicate.matches(List.of("test.txt"));
        List filtered = paths.stream().filter(predicate).toList();
        org.junit.jupiter.api.Assertions.assertEquals(paths, filtered);
    }

    @Test
    void shouldMatchGivenSimpleExpressionAndBasePath() {
        List<Path> paths = Stream.of("/base/test.txt", "/base/sub/dir/test.txt").map(x$0 -> Path.of(x$0, new String[0])).toList();
        PathMatcherPredicate predicate = PathMatcherPredicate.matches((Path)Path.of("/base", new String[0]), List.of("test.txt"));
        List filtered = paths.stream().filter(predicate).toList();
        org.junit.jupiter.api.Assertions.assertEquals(List.of(Path.of("/base/test.txt", new String[0])), filtered);
    }

    @Test
    void shouldMatchGivenIncludeAndExcludeExpressions() {
        List<Path> paths = List.of(Path.of("/a/b/c/1", new String[0]), Path.of("/a/2", new String[0]), Path.of("/b/c/d/3", new String[0]), Path.of("/b/d/4", new String[0]), Path.of("/c/5", new String[0]));
        Predicate predicate = PathMatcherPredicate.builder().includes(List.of("/a/**", "c/**")).excludes(List.of("**/2")).build();
        List filtered = paths.stream().filter(predicate).toList();
        Assertions.assertThat(filtered).containsExactlyInAnyOrder((Object[])new Path[]{Path.of("/a/b/c/1", new String[0]), Path.of("/b/c/d/3", new String[0]), Path.of("/c/5", new String[0])});
    }
}

