/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.ReadOnlyDelegatingMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ReadOnlyDelegatingMapTest {
    ReadOnlyDelegatingMapTest() {
    }

    @Test
    void readOnlyDelegatingMap() {
        TestMap map = new TestMap();
        Assertions.assertThat((Map)((Object)map)).hasSize(1);
        Assertions.assertThat((boolean)map.isEmpty()).isFalse();
        Assertions.assertThat((boolean)map.containsKey("key")).isTrue();
        Assertions.assertThat((boolean)map.containsValue("value")).isTrue();
        Assertions.assertThat((Collection)map.keySet()).hasSize(1);
        Assertions.assertThat((String)((String)map.get("key"))).isEqualTo("value");
        Assertions.assertThat((Collection)map.values()).hasSize(1);
        Assertions.assertThat((Collection)map.entrySet()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put("key", "value"));
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> map.putAll(Map.of("key", "value")));
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> map.clear());
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove("key"));
    }

    private static class TestMap
    extends ReadOnlyDelegatingMap<String, String> {
        private TestMap() {
        }

        protected Map<String, String> getDelegate() {
            return new HashMap<String, String>(Map.of("key", "value"));
        }
    }
}

