/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.models.tasks.retrys.Constant;
import io.kestra.core.utils.RetryUtils;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.Duration;
import java.util.ConcurrentModificationException;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class RetryUtilsTest {
    @Inject
    RetryUtils retryUtils;

    RetryUtilsTest() {
    }

    private <T, E extends Throwable> RetryUtils.Instance<T, E> instance() {
        return this.retryUtils.of((AbstractRetry)((Constant.ConstantBuilder)Constant.builder().interval(Duration.ofMillis(10L)).maxAttempts(Integer.valueOf(3))).build());
    }

    @Test
    void resultExceptionThrowRetryExceeded() {
        RetryUtils.Instance retrier = this.instance();
        AtomicInteger inc = new AtomicInteger(3);
        RetryUtils.RetryFailed retryFailed = (RetryUtils.RetryFailed)org.junit.jupiter.api.Assertions.assertThrows(RetryUtils.RetryFailed.class, () -> {
            retrier.run((o, throwable) -> {
                inc.decrementAndGet();
                return true;
            }, () -> true);
            Assertions.assertThat((int)inc.get()).isZero();
        });
        Assertions.assertThat((int)retryFailed.getAttemptCount()).isEqualTo(3);
    }

    @Test
    void resultNoExceptionRetryNotExceeded() throws Throwable {
        RetryUtils.Instance retrier = this.instance();
        AtomicInteger inc = new AtomicInteger(3);
        Boolean retry = (Boolean)retrier.run(o -> o == false, () -> inc.getAndDecrement() == 1);
        Assertions.assertThat((int)inc.get()).isZero();
        Assertions.assertThat((Boolean)retry).isTrue();
    }

    @Test
    void exceptionExceptionThrowRetryExceeded() {
        RetryUtils.Instance retrier = this.instance();
        AtomicInteger inc = new AtomicInteger(3);
        RetryUtils.RetryFailed retryFailed = (RetryUtils.RetryFailed)org.junit.jupiter.api.Assertions.assertThrows(RetryUtils.RetryFailed.class, () -> {
            retrier.run(IOException.class, () -> {
                throw new IOException("test");
            });
            Assertions.assertThat((int)inc.get()).isZero();
        });
        Assertions.assertThat((int)retryFailed.getAttemptCount()).isEqualTo(3);
    }

    @Test
    void exceptionNoExceptionRetryNotExceeded() throws Throwable {
        RetryUtils.Instance retrier = this.instance();
        AtomicInteger inc = new AtomicInteger(3);
        Boolean retry = (Boolean)retrier.run(IOException.class, () -> {
            boolean result;
            boolean bl = result = inc.getAndDecrement() == 1;
            if (!result) {
                throw new IOException("test");
            }
            return result;
        });
        Assertions.assertThat((int)inc.get()).isZero();
        Assertions.assertThat((Boolean)retry).isTrue();
    }

    @Test
    void exceptionNoRetry() {
        RetryUtils.Instance retrier = this.instance();
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> retrier.run(ConcurrentModificationException.class, () -> {
            throw new IOException("test");
        }));
    }
}

