/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.UnixModeToPosixFilePermissions;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UnixModeToPosixFilePermissionsTest {
    UnixModeToPosixFilePermissionsTest() {
    }

    @Test
    void shouldReturnPosixFilePermissions() {
        Assertions.assertThat((String)PosixFilePermissions.toString(UnixModeToPosixFilePermissions.toPosixPermissions((int)Integer.parseInt("700", 8)))).isEqualTo("rwx------");
        Assertions.assertThat((String)PosixFilePermissions.toString(UnixModeToPosixFilePermissions.toPosixPermissions((int)Integer.parseInt("620", 8)))).isEqualTo("rw--w----");
        Assertions.assertThat((String)PosixFilePermissions.toString(UnixModeToPosixFilePermissions.toPosixPermissions((int)Integer.parseInt("777", 8)))).isEqualTo("rwxrwxrwx");
        Assertions.assertThat((String)PosixFilePermissions.toString(UnixModeToPosixFilePermissions.toPosixPermissions((int)33188))).isEqualTo("rw-r--r--");
    }

    @Test
    void shouldReturnPosixFilePermissionsFromString() {
        Assertions.assertThat((String)Integer.toOctalString(UnixModeToPosixFilePermissions.fromPosixFilePermissions(Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE)))).isEqualTo("700");
        Assertions.assertThat((String)Integer.toOctalString(UnixModeToPosixFilePermissions.fromPosixFilePermissions(Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE)))).isEqualTo("620");
    }
}

