/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.utils.TestsUtils;
import io.kestra.core.utils.UriProvider;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class UriProviderTest {
    @Inject
    UriProvider uriProvider;

    UriProviderTest() {
    }

    @Test
    void root() {
        Assertions.assertThat((String)this.uriProvider.rootUrl().toString()).contains(new CharSequence[]{"mysuperhost.com/subpath/"});
    }

    @Test
    void flowUrl() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        Assertions.assertThat((String)this.uriProvider.executionUrl(execution).toString()).contains(new CharSequence[]{"mysuperhost.com/subpath/ui"});
        Assertions.assertThat((String)this.uriProvider.flowUrl(execution).toString()).contains(new CharSequence[]{flow.getNamespace() + "/" + flow.getId()});
        Assertions.assertThat((String)this.uriProvider.executionUrl(execution).toString()).contains(new CharSequence[]{"mysuperhost.com/subpath/ui"});
        Assertions.assertThat((String)this.uriProvider.flowUrl(flow).toString()).contains(new CharSequence[]{flow.getNamespace() + "/" + flow.getId()});
    }

    @Test
    void executionUrl() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        Assertions.assertThat((String)this.uriProvider.executionUrl(execution).toString()).contains(new CharSequence[]{"mysuperhost.com/subpath/ui"});
        Assertions.assertThat((String)this.uriProvider.executionUrl(execution).toString()).contains(new CharSequence[]{flow.getNamespace() + "/" + flow.getId() + "/" + execution.getId()});
    }

    @Test
    void tenant() {
        Flow flow = ((Flow.FlowBuilder)TestsUtils.mockFlow().toBuilder().tenantId("my-tenant")).build();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        Assertions.assertThat((String)this.uriProvider.executionUrl(execution).toString()).contains(new CharSequence[]{"mysuperhost.com/subpath/ui/my-tenant"});
        Assertions.assertThat((String)this.uriProvider.flowUrl(flow).toString()).contains(new CharSequence[]{"mysuperhost.com/subpath/ui/my-tenant"});
    }
}

