/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.utils.Version;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class VersionTest {
    VersionTest() {
    }

    @Test
    void shouldCreateVersionFromIntegerGivenMajorVersion() {
        Version version = Version.of((Object)1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)version.majorVersion());
    }

    @Test
    void shouldCreateVersionFromStringGivenMajorVersion() {
        Version version = Version.of((Object)"1");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)version.majorVersion());
    }

    @Test
    void shouldCreateVersionFromStringGivenMajorMinorVersion() {
        Version version = Version.of((Object)"1.2");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)version.majorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)version.minorVersion());
    }

    @Test
    void shouldCreateVersionFromStringGivenMajorMinorPatchVersion() {
        Version version = Version.of((Object)"1.2.3");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)version.majorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)version.minorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)version.patchVersion());
    }

    @Test
    void shouldCreateVersionFromPrefixedStringGivenMajorMinorPatchVersion() {
        Version version = Version.of((Object)"v1.2.3");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)version.majorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)version.minorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)version.patchVersion());
    }

    @Test
    void shouldCreateVersionFromStringGivenMajorMinorPatchAndQualifierVersion() {
        Version version = Version.of((Object)"1.2.3-SNAPSHOT");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)version.majorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)version.minorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)version.patchVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SNAPSHOT", (Object)version.qualifier().toString());
    }

    @Test
    void shouldCreateVersionFromStringGivenSnapshotSuffixedQualifierVersion() {
        Version version = Version.of((Object)"1.2.3-RC0-SNAPSHOT");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)version.majorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)version.minorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)version.patchVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"RC0-SNAPSHOT", (Object)version.qualifier().toString());
    }

    @Test
    void shouldThrowIllegalArgumentGivenInvalidVersion() {
        IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Version.of((Object)"bad input"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Invalid version, cannot parse 'bad input'", (Object)e.getMessage());
    }

    @Test
    void shouldGetLatestVersionGivenMajorVersions() {
        Version result = Version.getLatest((Version[])new Version[]{Version.of((Object)"1"), Version.of((Object)"3"), Version.of((Object)"2")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"3"), (Object)result);
    }

    @Test
    void shouldGetLatestVersionGivenMajorMinorVersions() {
        Version result = Version.getLatest((Version[])new Version[]{Version.of((Object)"1.2"), Version.of((Object)"1.0"), Version.of((Object)"1.10")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.10"), (Object)result);
    }

    @Test
    void shouldGetLatestVersionGivenMajorMinorPatchVersions() {
        Version result = Version.getLatest((Version[])new Version[]{Version.of((Object)"1.0.9"), Version.of((Object)"1.0.10"), Version.of((Object)"1.0.11")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.0.11"), (Object)result);
    }

    @Test
    public void shouldGetOldestVersionGivenMajorMinorPatchVersions() {
        Version result = Version.getOldest((Version[])new Version[]{Version.of((Object)"1.0.9"), Version.of((Object)"1.0.10"), Version.of((Object)"1.0.11")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.0.9"), (Object)result);
    }

    @Test
    public void shouldGetLatestVersionGivenMajorMinorIncrementalAndSimpleQualifierVersions() {
        Version result = Version.getLatest((Version[])new Version[]{Version.of((Object)"1.0.0"), Version.of((Object)"1.0.0-SNAPSHOT")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.0.0"), (Object)result);
        result = Version.getLatest((Version[])new Version[]{Version.of((Object)"1.0.0-ALPHA"), Version.of((Object)"1.0.0-BETA")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.0.0-BETA"), (Object)result);
        result = Version.getLatest((Version[])new Version[]{Version.of((Object)"1.0.0-RELEASE"), Version.of((Object)"1.0.0-SNAPSHOT")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.0.0-RELEASE"), (Object)result);
        result = Version.getLatest((Version[])new Version[]{Version.of((Object)"1.0.0-RC10"), Version.of((Object)"1.0.0-RC12")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.0.0-RC12"), (Object)result);
        result = Version.getLatest((Version[])new Version[]{Version.of((Object)"1.0.0-rc.10"), Version.of((Object)"1.0.0-rc.12")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.0.0-rc.12"), (Object)result);
    }

    @Test
    void shouldReturnTrueForEqualsGivenDifferentCase() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.0.0-rc.1"), (Object)Version.of((Object)"1.0.0-RC.1"));
    }

    @Test
    void shouldNotFailGivenUnknownQualifier() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> Version.of((Object)"1.0.0-custom10"));
        Version result = Version.getLatest((Version[])new Version[]{Version.of((Object)"1.0.0-custom10"), Version.of((Object)"1.0.0-SNAPSHOT")});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Version.of((Object)"1.0.0-SNAPSHOT"), (Object)result);
    }

    @Test
    void shouldReturnTrueGivenBeforeVersion() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Version.of((Object)"1.0.0").isBefore(Version.of((Object)"1.0.1")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Version.of((Object)"1.0.0").isBefore(Version.of((Object)"1.1.0")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Version.of((Object)"1.0.0").isBefore(Version.of((Object)"2.0.0")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Version.of((Object)"1.0.0-SNAPSHOT").isBefore(Version.of((Object)"1.0.0")));
    }

    @Test
    void shouldReturnFalseGivenNonBeforeVersion() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Version.of((Object)"1.0.0").isBefore(Version.of((Object)"1.0.0")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Version.of((Object)"1.0.1").isBefore(Version.of((Object)"1.0.0")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Version.of((Object)"1.1.0").isBefore(Version.of((Object)"1.0.0")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Version.of((Object)"2.0.0").isBefore(Version.of((Object)"2.0.0")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Version.of((Object)"1.0.0").isBefore(Version.of((Object)"1.0.0-SNAPSHOT")));
    }

    @Test
    public void shouldGetStableVersionGivenMajorMinorPatchVersion() {
        List<Version> versions = List.of(Version.of((Object)"1.2.1"), Version.of((Object)"1.2.3"), Version.of((Object)"0.99.0"));
        Assertions.assertThatObject((Object)Version.getStable((Version)Version.of((Object)"1.2.1"), versions)).isEqualTo((Object)Version.of((Object)"1.2.1"));
        Assertions.assertThatObject((Object)Version.getStable((Version)Version.of((Object)"1.2.0"), versions)).isNull();
        Assertions.assertThatObject((Object)Version.getStable((Version)Version.of((Object)"1.2.4"), versions)).isNull();
    }

    @Test
    public void shouldGetStableGivenMajorAndMinorVersionOnly() {
        List<Version> versions = List.of(Version.of((Object)"1.2.1"), Version.of((Object)"1.2.3"), Version.of((Object)"0.99.0"));
        Assertions.assertThatObject((Object)Version.getStable((Version)Version.of((Object)"1.2"), versions)).isEqualTo((Object)Version.of((Object)"1.2.3"));
    }

    @Test
    public void shouldGetStableGivenMajorVersionOnly() {
        List<Version> versions = List.of(Version.of((Object)"1.2.1"), Version.of((Object)"1.2.3"), Version.of((Object)"0.99.0"));
        Assertions.assertThatObject((Object)Version.getStable((Version)Version.of((Object)"1"), versions)).isEqualTo((Object)Version.of((Object)"1.2.3"));
    }

    @Test
    public void shouldGetNullForStableGivenMajorAndMinorVersionOnly() {
        List<Version> versions = List.of(Version.of((Object)"1.2.1"), Version.of((Object)"1.2.3"), Version.of((Object)"0.99.0"));
        Assertions.assertThatObject((Object)Version.getStable((Version)Version.of((Object)"2.0"), versions)).isNull();
        Assertions.assertThatObject((Object)Version.getStable((Version)Version.of((Object)"0.1"), versions)).isNull();
    }

    @Test
    public void shouldGetNullForStableGivenMajorVersionOnly() {
        List<Version> versions = List.of(Version.of((Object)"1.2.1"), Version.of((Object)"1.2.3"), Version.of((Object)"0.99.0"));
        Assertions.assertThatObject((Object)Version.getStable((Version)Version.of((Object)"2"), versions)).isNull();
    }
}

