/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.validations.AppConfigValidator;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.exceptions.BeanInstantiationException;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AppConfigValidatorTest {
    AppConfigValidatorTest() {
    }

    @Test
    void validateNoKestraUrl() {
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> {
            try (ApplicationContext context = ApplicationContext.run();){
                context.getBean(AppConfigValidator.class);
            }
        }).as("The bean got initialized properly including the PostConstruct validation", new Object[0])).doesNotThrowAnyException();
    }

    @Test
    void validateValidKestraUrl() {
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> {
            try (ApplicationContext context = ApplicationContext.builder().deduceEnvironment(Boolean.valueOf(false)).properties(Map.of("kestra.url", "https://postgres-oss.preview.dev.kestra.io")).start();){
                context.getBean(AppConfigValidator.class);
            }
        }).as("The bean got initialized properly including the PostConstruct validation", new Object[0])).doesNotThrowAnyException();
    }

    @Test
    void validateInvalidKestraUrl() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (ApplicationContext context = ApplicationContext.builder().deduceEnvironment(Boolean.valueOf(false)).properties(Map.of("kestra.url", "postgres-oss.preview.dev.kestra.io")).start();){
                context.getBean(AppConfigValidator.class);
            }
        }).as("The bean initialization failed at PostConstruct", new Object[0])).isInstanceOf(BeanInstantiationException.class)).hasMessageContaining("Invalid configuration");
    }

    @Test
    void validateNonHttpKestraUrl() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (ApplicationContext context = ApplicationContext.builder().deduceEnvironment(Boolean.valueOf(false)).properties(Map.of("kestra.url", "ftp://postgres-oss.preview.dev.kestra.io")).start();){
                context.getBean(AppConfigValidator.class);
            }
        }).as("The bean initialization failed at PostConstruct", new Object[0])).isInstanceOf(BeanInstantiationException.class)).hasMessageContaining("Invalid configuration");
    }
}

