/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.validations.DateFormat;
import io.micronaut.core.annotation.Introspected;
import jakarta.inject.Inject;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@KestraTest
class DateFormatTest {
    @Inject
    private ModelValidator modelValidator;

    DateFormatTest() {
    }

    static Stream<Arguments> formatSource() {
        return Stream.of(Arguments.of((Object[])new Object[]{"YYYY", "YYYYHH:mm", "H:mm", false, 0}), Arguments.of((Object[])new Object[]{"YYYYo", "YYYYHH:mm", "HH:mm", true, 1}), Arguments.of((Object[])new Object[]{"YYYYo", "YYYYHH:mm", "YYYY", true, 1}), Arguments.of((Object[])new Object[]{"YYYYo", "YYYYHH:mmo", "H:mm", true, 2}), Arguments.of((Object[])new Object[]{"YYYYo", "YYYYHH:mmo", "H:mmo", true, 3}));
    }

    @ParameterizedTest
    @MethodSource(value={"formatSource"})
    void format(String date, String dateTime, String time, Boolean present, int size) {
        DateFormatCls options = DateFormatCls.builder().dateFormat(date).datetimeFormat(dateTime).timeFormat(time).build();
        Optional valid = this.modelValidator.isValid((Object)options);
        Assertions.assertThat((boolean)valid.isPresent()).isEqualTo((Object)present);
        valid.ifPresent(e -> Assertions.assertThat((int)e.getConstraintViolations().size()).isEqualTo(size));
    }

    @Introspected
    public static class DateFormatCls {
        @DateFormat
        String dateFormat;
        @DateFormat
        String datetimeFormat;
        @DateFormat
        String timeFormat;

        @Generated
        public static DateFormatClsBuilder builder() {
            return new DateFormatClsBuilder();
        }

        @ConstructorProperties(value={"dateFormat", "datetimeFormat", "timeFormat"})
        @Generated
        public DateFormatCls(String dateFormat, String datetimeFormat, String timeFormat) {
            this.dateFormat = dateFormat;
            this.datetimeFormat = datetimeFormat;
            this.timeFormat = timeFormat;
        }

        @Generated
        public String getDateFormat() {
            return this.dateFormat;
        }

        @Generated
        public String getDatetimeFormat() {
            return this.datetimeFormat;
        }

        @Generated
        public String getTimeFormat() {
            return this.timeFormat;
        }

        @Generated
        public static class DateFormatClsBuilder {
            @Generated
            private String dateFormat;
            @Generated
            private String datetimeFormat;
            @Generated
            private String timeFormat;

            @Generated
            DateFormatClsBuilder() {
            }

            @Generated
            public DateFormatClsBuilder dateFormat(String dateFormat) {
                this.dateFormat = dateFormat;
                return this;
            }

            @Generated
            public DateFormatClsBuilder datetimeFormat(String datetimeFormat) {
                this.datetimeFormat = datetimeFormat;
                return this;
            }

            @Generated
            public DateFormatClsBuilder timeFormat(String timeFormat) {
                this.timeFormat = timeFormat;
                return this;
            }

            @Generated
            public DateFormatCls build() {
                return new DateFormatCls(this.dateFormat, this.datetimeFormat, this.timeFormat);
            }

            @Generated
            public String toString() {
                return "DateFormatTest.DateFormatCls.DateFormatClsBuilder(dateFormat=" + this.dateFormat + ", datetimeFormat=" + this.datetimeFormat + ", timeFormat=" + this.timeFormat + ")";
            }
        }
    }
}

