/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.tasks.retrys.Exponential;
import io.kestra.core.models.validations.ModelValidator;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class ExponentialRetryValidationTest {
    @Inject
    private ModelValidator modelValidator;

    @Test
    void shouldValidateValidRetry() throws Exception {
        Exponential retry = ((Exponential.ExponentialBuilder)((Exponential.ExponentialBuilder)Exponential.builder().maxAttempts(Integer.valueOf(3))).maxDuration(Duration.ofSeconds(10L))).interval(Duration.ofSeconds(1L)).maxInterval(Duration.ofSeconds(3L)).build();
        Optional valid = this.modelValidator.isValid((Object)retry);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }

    @Test
    void shouldNotValidateInvalidRetry() throws Exception {
        Exponential retry = ((Exponential.ExponentialBuilder)((Exponential.ExponentialBuilder)Exponential.builder().maxAttempts(Integer.valueOf(3))).maxDuration(Duration.ofSeconds(1L))).interval(Duration.ofSeconds(2L)).maxInterval(Duration.ofSeconds(3L)).build();
        Optional valid = this.modelValidator.isValid((Object)retry);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": 'interval' must be less than 'maxDuration' but is PT2S\n");
        retry = ((Exponential.ExponentialBuilder)((Exponential.ExponentialBuilder)Exponential.builder().maxAttempts(Integer.valueOf(3))).maxDuration(Duration.ofSeconds(12L))).interval(Duration.ofSeconds(3L)).maxInterval(Duration.ofSeconds(2L)).build();
        valid = this.modelValidator.isValid((Object)retry);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": 'interval' must be less than 'maxInterval' but is PT3S\n");
    }
}

