/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.serializers.YamlParser;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class FlowValidationTest {
    @Inject
    private ModelValidator modelValidator;

    FlowValidationTest() {
    }

    @Test
    void invalidRecursiveFlow() {
        Flow flow = this.parse("flows/invalids/recursive-flow.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{": Invalid Flow: Recursive call to flow [io.kestra.tests.recursive-flow]"});
    }

    @Test
    void systemLabelShouldFailValidation() {
        Flow flow = this.parse("flows/invalids/system-labels.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"System labels can only be set by Kestra itself, offending label: system.label=system_key"});
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"System labels can only be set by Kestra itself, offending label: system.id=id"});
    }

    @Test
    void inputUsageWithSubtractionSymbolFailValidation() {
        Flow flow = this.parse("flows/invalids/inputs-key-with-subtraction-symbol-validation.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isEqualTo(true);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Invalid input reference: use inputs[key-name] instead of inputs.key-name \u2014 keys with dashes require bracket notation, offending tasks: [hello]"});
    }

    @Test
    void outputUsageWithSubtractionSymbolFailValidation() {
        Flow flow = this.parse("flows/invalids/outputs-key-with-subtraction-symbol-validation.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isEqualTo(true);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Invalid output reference: use outputs[key-name] instead of outputs.key-name \u2014 keys with dashes require bracket notation, offending tasks: [use_output]"});
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Invalid output reference: use outputs[key-name] instead of outputs.key-name \u2014 keys with dashes require bracket notation, offending outputs: [final]"});
    }

    @Test
    void validFlowShouldSucceed() {
        Flow flow = this.parse("flows/valids/minimal.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isFalse();
    }

    @Test
    void shouldGetConstraintErrorGivenInputWithBothDefaultsAndPrefill() {
        GenericFlow flow = GenericFlow.fromYaml((String)"main", (String)"id: test\nnamespace: unittest\ninputs:\n  - id: input\n    type: STRING\n    prefill: \"suggestion\"\n    defaults: \"defaults\"\ntasks: []\n");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isEqualTo(true);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Inputs with a default value cannot also have a prefill."});
    }

    @Test
    void shouldGetConstraintErrorGivenOptionalInputWithDefault() {
        GenericFlow flow = GenericFlow.fromYaml((String)"main", (String)"id: test\nnamespace: unittest\ninputs:\n  - id: input\n    type: STRING\n    defaults: \"defaults\"\n    required: false\ntasks: []\n");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isEqualTo(true);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Inputs with a default value must be required, since the default is always applied."});
    }

    @Test
    void duplicatePreconditionsIdShouldFailValidation() {
        Flow flow = this.parse("flows/invalids/duplicate-preconditions.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isEqualTo(true);
        Assertions.assertThat((String)((ConstraintViolationException)validate.get()).getMessage()).contains(new CharSequence[]{"Duplicate preconditions with id [flows]"});
    }

    private Flow parse(String path) {
        URL resource = TestsUtils.class.getClassLoader().getResource(path);
        assert (resource != null);
        File file = new File(resource.getFile());
        return (Flow)YamlParser.parse((File)file, Flow.class);
    }
}

