/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.FileInput;
import io.kestra.core.models.flows.input.StringInput;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.validations.ModelValidator;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class InputTest {
    @Inject
    private ModelValidator modelValidator;

    InputTest() {
    }

    @Test
    void inputValidation() {
        StringInput validInput = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id("test")).type(Type.STRING)).validator("[A-Z]+").build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)validInput).isEmpty()).isTrue();
    }

    @Test
    void inputNameDeprecation() {
        String id = "test";
        StringInput validInput = ((StringInput.StringInputBuilder)((StringInput.StringInputBuilder)StringInput.builder().id(id)).type(Type.STRING)).build();
        Assertions.assertThat((String)validInput.getId()).isEqualTo(id);
        Assertions.assertThat((String)validInput.getName()).isNull();
        String newName = "newName";
        validInput = ((StringInput.StringInputBuilder)StringInput.builder().type(Type.STRING)).build();
        validInput.setName(newName);
        Assertions.assertThat((String)validInput.getName()).isEqualTo(newName);
        Assertions.assertThat((String)validInput.getId()).isEqualTo(newName);
    }

    @Test
    void shouldFailFileInputWithDefault() {
        FileInput fileInput = ((FileInput.FileInputBuilder)((FileInput.FileInputBuilder)((FileInput.FileInputBuilder)FileInput.builder().id("test")).type(Type.FILE)).defaults(Property.ofValue((Object)URI.create("http://some.uri")))).build();
        Assertions.assertThat((Optional)this.modelValidator.isValid((Object)fileInput)).isPresent();
    }

    @Test
    void shouldValidateFileInputWithFileDefault() {
        FileInput fileInput = ((FileInput.FileInputBuilder)((FileInput.FileInputBuilder)((FileInput.FileInputBuilder)FileInput.builder().id("test")).type(Type.FILE)).defaults(Property.ofValue((Object)URI.create("file:///tmp.file.txt")))).build();
        Assertions.assertThat((Optional)this.modelValidator.isValid((Object)fileInput)).isEmpty();
    }
}

