/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.validations.JsonString;
import io.micronaut.core.annotation.Introspected;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class JsonStringTest {
    @Inject
    private ModelValidator modelValidator;

    JsonStringTest() {
    }

    @Test
    void jsonString() throws Exception {
        JsonStringCls build = new JsonStringCls("{}");
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)build).isEmpty()).isTrue();
        build = new JsonStringCls("{\"invalid\"}");
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)build).isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)this.modelValidator.isValid((Object)build).get()).getMessage()).contains(new CharSequence[]{"invalid json"});
    }

    @Introspected
    public static class JsonStringCls {
        @JsonString
        String json;

        @ConstructorProperties(value={"json"})
        @Generated
        public JsonStringCls(String json) {
            this.json = json;
        }

        @Generated
        public String getJson() {
            return this.json;
        }
    }
}

