/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.flows.sla.SLA;
import io.kestra.core.models.flows.sla.types.MaxDurationSLA;
import io.kestra.core.models.validations.ModelValidator;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class NoSystemLabelValidationTest {
    @Inject
    private ModelValidator modelValidator;

    NoSystemLabelValidationTest() {
    }

    @Test
    void shouldReportAViolation() {
        MaxDurationSLA sla = ((MaxDurationSLA.MaxDurationSLABuilder)((MaxDurationSLA.MaxDurationSLABuilder)((MaxDurationSLA.MaxDurationSLABuilder)((MaxDurationSLA.MaxDurationSLABuilder)MaxDurationSLA.builder().duration(Duration.ofSeconds(1L)).id("id")).behavior(SLA.Behavior.CANCEL)).type(SLA.Type.MAX_DURATION)).labels(List.of(new Label("system.sla", "violated")))).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo("labels[0].<list element>: System labels can only be set by Kestra itself, offending label: system.sla=violated.\n");
    }

    @Test
    void shouldSuccess() {
        MaxDurationSLA sla = ((MaxDurationSLA.MaxDurationSLABuilder)((MaxDurationSLA.MaxDurationSLABuilder)((MaxDurationSLA.MaxDurationSLABuilder)((MaxDurationSLA.MaxDurationSLABuilder)MaxDurationSLA.builder().duration(Duration.ofSeconds(1L)).id("id")).behavior(SLA.Behavior.CANCEL)).type(SLA.Type.MAX_DURATION)).labels(List.of(new Label("sla", "violated")))).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }
}

