/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.flows.PluginDefault;
import io.kestra.core.models.validations.ModelValidator;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class PluginDefaultValidationTest {
    @Inject
    private ModelValidator modelValidator;

    PluginDefaultValidationTest() {
    }

    @Test
    void nullValuesShouldViolate() {
        PluginDefault pluginDefault = PluginDefault.builder().type("io.kestra.tests").build();
        Optional validate = this.modelValidator.isValid((Object)pluginDefault);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
    }

    @Test
    void nullPropertiesShouldViolate() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("nullProperty", null);
        PluginDefault pluginDefault = PluginDefault.builder().type("io.kestra.tests").values(props).build();
        Optional validate = this.modelValidator.isValid((Object)pluginDefault);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
    }

    @Test
    void unknownPropertyShouldViolate() {
        PluginDefault pluginDefault = PluginDefault.builder().type("io.kestra.plugin.core.log.Log").values(Map.of("not", "existing")).build();
        Optional validate = this.modelValidator.isValid((Object)pluginDefault);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
    }

    @Test
    void unknownPropertyOnUnknownPluginShouldPass() {
        PluginDefault pluginDefault = PluginDefault.builder().type("io.kestra.plugin.core.log").values(Map.of("not", "existing")).build();
        Optional validate = this.modelValidator.isValid((Object)pluginDefault);
        Assertions.assertThat((boolean)validate.isEmpty()).isTrue();
    }

    @Test
    void validShouldPass() {
        PluginDefault pluginDefault = PluginDefault.builder().type("io.kestra.plugin.core.log.Log").values(Map.of("level", "WARN")).build();
        Optional validate = this.modelValidator.isValid((Object)pluginDefault);
        Assertions.assertThat((boolean)validate.isEmpty()).isTrue();
    }
}

