/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.plugin.core.trigger.Flow;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@KestraTest
class PreconditionFilterValidationTest {
    @Inject
    private ModelValidator modelValidator;

    PreconditionFilterValidationTest() {
    }

    @ParameterizedTest
    @EnumSource(value=Flow.Type.class, names={"EQUAL_TO", "NOT_EQUAL_TO", "IS_NULL", "IS_NOT_NULL", "IS_TRUE", "IS_FALSE", "STARTS_WITH", "ENDS_WITH", "REGEX", "CONTAINS"})
    void shouldValidateConditionWithAValue(Flow.Type type) {
        Flow.Filter condition = Flow.Filter.builder().field(Flow.Field.FLOW_ID).type(type).value("myFlow").build();
        Optional valid = this.modelValidator.isValid((Object)condition);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }

    @ParameterizedTest
    @EnumSource(value=Flow.Type.class, names={"EQUAL_TO", "NOT_EQUAL_TO", "IS_NULL", "IS_NOT_NULL", "IS_TRUE", "IS_FALSE", "STARTS_WITH", "ENDS_WITH", "REGEX", "CONTAINS"})
    void shouldNotValidateConditionWithValues(Flow.Type type) {
        Flow.Filter condition = Flow.Filter.builder().field(Flow.Field.FLOW_ID).type(type).values(List.of("myFlow1", "myFlow2")).build();
        Optional valid = this.modelValidator.isValid((Object)condition);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": `value` cannot be null for type " + type.name() + "\n");
    }

    @ParameterizedTest
    @EnumSource(value=Flow.Type.class, names={"EQUAL_TO", "NOT_EQUAL_TO", "IS_NULL", "IS_NOT_NULL", "IS_TRUE", "IS_FALSE", "STARTS_WITH", "ENDS_WITH", "REGEX", "CONTAINS"})
    void shouldNotValidateConditionWithAValueAndValues(Flow.Type type) {
        Flow.Filter condition = Flow.Filter.builder().field(Flow.Field.FLOW_ID).type(type).value("myFlow").values(List.of("myFlow1", "myFlow2")).build();
        Optional valid = this.modelValidator.isValid((Object)condition);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": `values` must be null for type " + type.name() + "\n");
    }

    @ParameterizedTest
    @EnumSource(value=Flow.Type.class, names={"IN", "NOT_IN"})
    void shouldValidateConditionWithValues(Flow.Type type) {
        Flow.Filter condition = Flow.Filter.builder().field(Flow.Field.FLOW_ID).type(type).values(List.of("myFlow1", "myFlow2")).build();
        Optional valid = this.modelValidator.isValid((Object)condition);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }

    @ParameterizedTest
    @EnumSource(value=Flow.Type.class, names={"IN", "NOT_IN"})
    void shouldNotValidateConditionWithAValue(Flow.Type type) {
        Flow.Filter condition = Flow.Filter.builder().field(Flow.Field.FLOW_ID).type(type).value("myFlow1").build();
        Optional valid = this.modelValidator.isValid((Object)condition);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": `value` must be null for type " + type.name() + "\n");
    }
}

