/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.tasks.retrys.Random;
import io.kestra.core.models.validations.ModelValidator;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class RandomRetryValidationTest {
    @Inject
    private ModelValidator modelValidator;

    @Test
    void shouldValidateValidRetry() throws Exception {
        Random retry = ((Random.RandomBuilder)((Random.RandomBuilder)Random.builder().maxAttempts(Integer.valueOf(3))).maxDuration(Duration.ofSeconds(10L))).minInterval(Duration.ofSeconds(1L)).maxInterval(Duration.ofSeconds(3L)).build();
        Optional valid = this.modelValidator.isValid((Object)retry);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }

    @Test
    void shouldNotValidateInvalidRetry() throws Exception {
        Random retry = ((Random.RandomBuilder)((Random.RandomBuilder)Random.builder().maxAttempts(Integer.valueOf(3))).maxDuration(Duration.ofSeconds(1L))).minInterval(Duration.ofSeconds(2L)).maxInterval(Duration.ofSeconds(3L)).build();
        Optional valid = this.modelValidator.isValid((Object)retry);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": 'minInterval' must be less than 'maxDuration' but is PT2S\n");
        retry = ((Random.RandomBuilder)((Random.RandomBuilder)Random.builder().maxAttempts(Integer.valueOf(3))).maxDuration(Duration.ofSeconds(12L))).minInterval(Duration.ofSeconds(3L)).maxInterval(Duration.ofSeconds(2L)).build();
        valid = this.modelValidator.isValid((Object)retry);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": 'minInterval' must be less than 'maxInterval' but is PT3S\n");
    }
}

