/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.validations.Regex;
import io.micronaut.core.annotation.Introspected;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class RegexTest {
    @Inject
    private ModelValidator modelValidator;

    RegexTest() {
    }

    @Test
    void inputValidation() {
        RegexCls validRegex = new RegexCls("[A-Z]+");
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)validRegex).isEmpty()).isTrue();
        RegexCls invalidRegex = new RegexCls("\\");
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)invalidRegex).isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)this.modelValidator.isValid((Object)invalidRegex).get()).getMessage()).contains(new CharSequence[]{"invalid pattern"});
    }

    @Introspected
    public static class RegexCls {
        @Regex
        String pattern;

        @ConstructorProperties(value={"pattern"})
        @Generated
        public RegexCls(String pattern) {
            this.pattern = pattern;
        }

        @Generated
        public String getPattern() {
            return this.pattern;
        }
    }
}

