/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.trigger.Schedule;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.time.Duration;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ScheduleValidationTest {
    @Inject
    private ModelValidator modelValidator;

    ScheduleValidationTest() {
    }

    @Test
    void cronValidation() throws Exception {
        Schedule build = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id(IdUtils.create())).type(Schedule.class.getName())).cron("* * * * *").build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)build).isEmpty()).isTrue();
        build = ((Schedule.ScheduleBuilder)Schedule.builder().type(Schedule.class.getName())).cron("$ome Inv@lid Cr0n").build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)build).isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)this.modelValidator.isValid((Object)build).get()).getMessage()).contains(new CharSequence[]{"invalid cron expression"});
    }

    @Test
    void nicknameValidation() throws Exception {
        Schedule build = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id(IdUtils.create())).type(Schedule.class.getName())).cron("@hourly").build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)build).isEmpty()).isTrue();
    }

    @Test
    void withSecondsValidation() throws Exception {
        Schedule build = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id(IdUtils.create())).type(Schedule.class.getName())).withSeconds(Boolean.valueOf(true)).cron("* * * * * *").build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)build).isEmpty()).isTrue();
        build = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id(IdUtils.create())).type(Schedule.class.getName())).cron("* * * * * *").build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)build).isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)this.modelValidator.isValid((Object)build).get()).getMessage()).contains(new CharSequence[]{"invalid cron expression"});
    }

    @Test
    void lateMaximumDelayValidation() {
        Schedule build = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id(IdUtils.create())).type(Schedule.class.getName())).cron("* * * * *").lateMaximumDelay(Duration.ofSeconds(10L)).build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)build).isPresent()).isFalse();
    }

    @Test
    void intervalValidation() {
        Schedule build = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id(IdUtils.create())).type(Schedule.class.getName())).cron("* * * * *").interval(Duration.ofSeconds(5L)).build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)build).isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)this.modelValidator.isValid((Object)build).get()).getMessage()).contains(new CharSequence[]{"interval: must be null"});
    }

    @Test
    void sundayDayOfTheWeekAlias() {
        Schedule sundayAsZero = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id(IdUtils.create())).type(Schedule.class.getName())).cron("0 9 * * 0").build();
        Assertions.assertThat((Optional)this.modelValidator.isValid((Object)sundayAsZero)).isNotPresent();
        Schedule sundayAsSeven = ((Schedule.ScheduleBuilder)((Schedule.ScheduleBuilder)Schedule.builder().id(IdUtils.create())).type(Schedule.class.getName())).cron("0 9 * * 7").build();
        Assertions.assertThat((Optional)this.modelValidator.isValid((Object)sundayAsSeven)).isNotPresent();
    }
}

