/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.validations.ServerCommandValidator;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ServerCommandValidatorTest {
    ServerCommandValidatorTest() {
    }

    @Test
    void noServerCommandIssued() {
        try (ApplicationContext context = ApplicationContext.run();){
            org.junit.jupiter.api.Assertions.assertThrows(NoSuchBeanException.class, () -> context.getBean(ServerCommandValidator.class));
        }
    }

    @Test
    void serverCommandIssued() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ApplicationContext.builder().deduceEnvironment(Boolean.valueOf(false)).properties(Map.of("kestra.server-type", "webserver", "kestra.queue.type", "memory", "kestra.repository.type", "memory", "kestra.storage.type", "local")).start());
        Throwable exception = org.junit.jupiter.api.Assertions.assertThrows(BeanInstantiationException.class, () -> ApplicationContext.builder().deduceEnvironment(Boolean.valueOf(false)).properties(Map.of("kestra.server-type", "webserver")).start());
        Throwable rootException = this.getRootException(exception);
        Assertions.assertThat(rootException.getClass()).isEqualTo(ServerCommandValidator.ServerCommandException.class);
        Assertions.assertThat((String)rootException.getMessage()).isEqualTo("Incomplete server configuration - missing required properties");
    }

    private Throwable getRootException(Throwable exception) {
        while (exception.getCause() != null) {
            exception = exception.getCause();
        }
        return exception;
    }
}

