/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.triggers.TimeWindow;
import io.kestra.core.models.validations.ModelValidator;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class TimeWindowValidationTest {
    @Inject
    private ModelValidator modelValidator;

    TimeWindowValidationTest() {
    }

    @Test
    void shouldDefaultTimeWindow() {
        TimeWindow sla = TimeWindow.builder().build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }

    @Test
    void shouldValidateDailyDeadline() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.DAILY_TIME_DEADLINE).deadline(LocalTime.now()).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }

    @Test
    void shouldNotValidateDailyDeadlineWhenMissingParam() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.DAILY_TIME_DEADLINE).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": Time window of type `DAILY_TIME_DEADLINE` must have a deadline.\n");
    }

    @Test
    void shouldNotValidateDailyDeadlineWhenInvalidParam() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.DAILY_TIME_DEADLINE).deadline(LocalTime.now()).window(Duration.ofHours(1L)).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": Time window of type `DAILY_TIME_DEADLINE` cannot have a window.\n");
    }

    @Test
    void shouldValidateDailyTimeWindow() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.DAILY_TIME_WINDOW).startTime(LocalTime.now()).endTime(LocalTime.now()).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }

    @Test
    void shouldNotValidateDailyTimeWindowWhenMissingParam() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.DAILY_TIME_WINDOW).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(2);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).contains(new CharSequence[]{": Time window of type `DAILY_TIME_WINDOW` must have an end time.\n"});
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).contains(new CharSequence[]{": Time window of type `DAILY_TIME_WINDOW` must have a start time.\n"});
    }

    @Test
    void shouldNotValidateDailyTimeWindowWhenInvalidParam() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.DAILY_TIME_WINDOW).startTime(LocalTime.now()).endTime(LocalTime.now()).window(Duration.ofHours(1L)).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(2);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).contains(new CharSequence[]{": Time window of type `DAILY_TIME_WINDOW` cannot have a window.\n"});
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).contains(new CharSequence[]{": Time window of type `DAILY_TIME_WINDOW` cannot have a deadline.\n"});
    }

    @Test
    void shouldValidateDurationWindow() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.DURATION_WINDOW).window(Duration.ofHours(1L)).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }

    @Test
    void shouldNotValidateDurationWindowWhenInvalidParam() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.DURATION_WINDOW).deadline(LocalTime.now()).window(Duration.ofHours(1L)).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": Time window of type `DURATION_WINDOW` cannot have a deadline.\n");
    }

    @Test
    void shouldValidateSlidingWindow() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.SLIDING_WINDOW).window(Duration.ofHours(1L)).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isTrue();
    }

    @Test
    void shouldNotValidateSlidingWindowWhenInvalidParam() {
        TimeWindow sla = TimeWindow.builder().type(TimeWindow.Type.SLIDING_WINDOW).deadline(LocalTime.now()).window(Duration.ofHours(1L)).build();
        Optional valid = this.modelValidator.isValid((Object)sla);
        Assertions.assertThat((boolean)valid.isEmpty()).isFalse();
        Assertions.assertThat((Collection)((ConstraintViolationException)valid.get()).getConstraintViolations()).hasSize(1);
        Assertions.assertThat((String)((ConstraintViolationException)valid.get()).getMessage()).isEqualTo(": Time window of type `SLIDING_WINDOW` cannot have a deadline.\n");
    }
}

